/*
 * Copyright (C) 2007-2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core;

import java.io.IOException;
import javax.inject.Inject;
import org.infodb.wax.core.html.AbstractBody;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class WikiFilter extends XMLFilterImpl {
    private static final String ELEMENT_NAME = "wiki";

    private boolean wikiMode;
    private WikiProcessor processor;
    private HTMLBuilder builder;

    @Inject
    public WikiFilter(WikiProcessor processor, HTMLBuilder builder) {
        super();
        this.processor = processor;
        this.builder = builder;
        wikiMode = false;
    }
    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (wikiMode == true) {
            try {
                AbstractBody body = builder.next(null);
                processor.parse(new String(ch, start, length), body);
            } catch (IOException e) {
                throw new SAXException(e.getMessage(), e);
            }
        } else {
            super.characters(ch, start, length);
        }
    }
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals(ELEMENT_NAME)) {
            wikiMode = false;
        } else {
            super.endElement(uri, localName, qName);
        }
    }
    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals(ELEMENT_NAME)) {
            wikiMode = true;
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }
}
