package org.infodb.wax.core;

import java.io.IOException;
import org.infodb.wax.core.html.AbstractBody;

/**
 * ヘッダ部に追加するメニューを扱うインターフェイス
 */
public interface HeaderMenu {
    /**
     * メニューの並び順を指定する。
     * @return 
     */
    int getOrderNo();
    /**
     * メニュー構築用のメソッド
     * HTMLでプラグインの動作をするリンク等を作成する。
     * @param target 処理しているページのURL
     * @param body HTMLタグクラス
     * @throws IOException 
     */
    void build(String target, AbstractBody body) throws IOException;
}
