package org.infodb.wax.core;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.infodb.wax.core.html.ARTICLE;
import org.infodb.wax.core.html.AbstractBody;
import org.infodb.wax.core.html.Attr;
import org.infodb.wax.core.html.BODY;
import org.infodb.wax.core.html.HEAD;
import org.infodb.wax.core.html.HEADER;
import org.infodb.wax.core.html.HTML5;
import org.infodb.wax.core.html.NAV;
import org.infodb.wax.core.html.UL;

public class HTMLBuilder {
    private Writer writer;

    private String target;
    private String title;
    
    private HTML5 html = null;
    private BODY body = null;
    private ARTICLE article = null;
    private NAV nav = null;
    
    private List<HeaderMenu> menuList;

    public HTMLBuilder(Writer writer, String target, String title, List<HeaderMenu> list) {
        this.writer = writer;
        this.target = target;
        this.title = title;
        this.menuList = list;
    }
    // TODO:追加のスクリプトやcssを追加するメソッドの追加
    
    public AbstractBody next(String clazz) throws IOException {
        if(html == null) { // Step.1
            html = new HTML5(writer);
            HEAD head = html.head();
            head.meta(Attr.charset("UTF-8"));
            head.link(Attr.rel("stylesheet"), Attr.href("default.css"));
            // TODO:スクリプトのタグ。jqueryとか
            head.title(title);
            head.end();
            body = html.body();
            HEADER header = body.header();
            header.h1().text(title).end();
            if(menuList != null) {
                UL ul = header.ul();
                for(HeaderMenu menu : menuList) {
                    menu.build(target, header);
                }
                ul.end();
            }
            header.end();
            
            if(clazz == null) {
                article = body.article();
            } else {
                article = body.article(Attr.clazz(clazz));
            }
            return article;
        }
        if(article != null) {
            article.end();
            article = null;
        }
        if(nav != null) {
            nav.end();
        }
        if(clazz == null) {
            nav = body.nav();
        } else {
            nav = body.nav(Attr.clazz(clazz));
        }
        return nav;
    }
    public void end() throws IOException {
        if(article != null) {
            article.end();
        }
        if(nav != null) {
            nav.end();
        }
        if(html != null) {
            // TODO:FOOTER
            body.end();
            html.end();
        }
    }
}
