/*
 * $Id$
 */

////////////////////////////////////////////////////////////////////////////////////
// Template file for plugin.
//
// You can modify and redistribute this file without any permission.
//
// Note:
// Create a sub folder under "PlugInSDK" folder. e.g. "PlugInSDK\MyProject\" and
// place your project files there.

#pragma warning(disable : 4996)

#include <windows.h>
#include <shlwapi.h>
#include <map>
#include <algorithm>
#include "BkTripleDango.h"
#include "BeckyAPI.h"
#include "BkCommon.h"

CBeckyAPI bka; // You can have only one instance in a project.

HWND hWndMain,hWndTree,hWndList,hWndView;	
HINSTANCE g_hInstance = NULL;
WNDPROC g_orgWindProc = NULL;

BOOL g_bExec = FALSE;
DWORD g_tickCount = 0;
LPARAM g_LButtonDblClk = NULL;

#ifdef __cplusplus
extern "C"{
#endif

// DLL entry point
BOOL APIENTRY DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
{
	g_hInstance = (HINSTANCE)hModule;
	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			if (!bka.InitAPI())
				return FALSE;
			break;
		case DLL_THREAD_ATTACH:
			break;
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
			break;
	}
	return TRUE;
}


// Callback Window Procedure for Becky! View Window
LRESULT CALLBACK ViewWindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if(uMsg == WM_LBUTTONUP)
	{
		if(g_bExec)
		{
			if(OpenClipboard(NULL))
			{
				HANDLE handle = GetClipboardData(CF_TEXT);
				if(handle)
				{
					std::string text;
					LPSTR pStr = (LPSTR)GlobalLock(handle);
					text = pStr;
					GlobalUnlock(handle);

					if(BKTD::ExtraFile(text))
					{
						if(wParam & MK_CONTROL)
						{
							BKTD::ExecuteFile(text);
						}
						else
						{
							BKTD::OpenFile(text);
						}

					}
				}
				CloseClipboard();
			}
			g_bExec = FALSE;
		}
	}
	
	if(uMsg == WM_LBUTTONDBLCLK)
	{
		g_tickCount = GetTickCount();
		g_LButtonDblClk = lParam;
		
		if(wParam & MK_CONTROL)
			mouse_event(MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0);
	}
	else if(uMsg == WM_LBUTTONDOWN)
	{
		if(GetTickCount() - g_tickCount < 500 && g_LButtonDblClk == lParam)
		{
			keybd_event(VK_CONTROL, 0, 0, 0);
			keybd_event(0x43, 0, 0, 0);
			keybd_event(0x43, 0, KEYEVENTF_KEYUP, 0);
			keybd_event(VK_CONTROL, 0, KEYEVENTF_KEYUP, 0);
			g_bExec = TRUE;
		}
	}

	return(CallWindowProc(g_orgWindProc, hWnd, uMsg, wParam, lParam));
}


BOOL BKTD::ExtraFile(std::string& file)
{
	std::string::size_type pos = file.find("\\\\");
	if(pos == std::string::npos)
		return FALSE;
	
	file = file.substr(pos);
	for(int i = 0; i < (signed)file.length(); i++)
	{
		char c = file[i];
		if(c == 0x0A || c == 0x0D)
		{
			file[i] = '\0';
			break;
		}
	}

	int pos1,pos2;
	while(TRUE)
	{
		if(PathFileExists(file.c_str()))
			return TRUE;
		
		pos1 = file.rfind(' ');
		pos2 = file.rfind("@");

		if(pos1 == std::string::npos && pos2 == std::string::npos)
		{
			MessageBox(hWndMain, file.c_str(), "t@C ܂ tH_`", MB_OK | MB_ICONERROR);
			return FALSE;
		}
		if(pos1 > pos2)
			file = file.substr(0, pos1);
		else
			file = file.substr(0, pos2);
	}

	return FALSE;
}

void BKTD::OpenFile(const std::string& file)
{
	int pos = file.rfind('\\');
	if(pos == std::string::npos)
		ShellExecute(hWndMain, "explore", file.c_str(), NULL, NULL, SW_SHOWNORMAL);
	else
	{
		if(PathIsDirectory(file.c_str()))
		{
			ShellExecute(hWndMain, "explore", file.c_str(), NULL, NULL, SW_SHOWNORMAL);
		}
		else
		{
			std::string param("/e, /select,");
			param += file;
			ShellExecute(hWndMain, "open", "Explorer.exe", param.c_str(), NULL, SW_SHOWNORMAL);
		}
	}
	return;
}

void BKTD::ExecuteFile(const std::string& file)
{
	ShellExecute(hWndMain, "open", file.c_str(), NULL, NULL, SW_SHOWNORMAL);
	return;
}


// Called when the program is started and the main window is created.
int WINAPI BKC_OnStart()
{
	/*
	Since BKC_OnStart is called after Becky!'s main window is
	created, at least BKC_OnMenuInit with BKC_MENU_MAIN is called
	before BKC_OnStart. So, do not assume BKC_OnStart is called
	prior to any other callback.
	*/
	// Always return 0.
	
	bka.GetWindowHandles(&hWndMain, &hWndTree, &hWndList, &hWndView);
	g_orgWindProc = (WNDPROC)SetWindowLong(hWndView, GWL_WNDPROC, (LONG)ViewWindowProc);
	return 0;
}

// Called when plug-in information is being retrieved.
typedef struct tagBKPLUGININFO
{
	char szPlugInName[80]; // Name of the plug-in
	char szVendor[80]; // Name of the vendor
	char szVersion[80]; // Version string
	char szDescription[256]; // Short description about this plugin
} BKPLUGININFO, *LPBKPLUGININFO;

int WINAPI BKC_OnPlugInInfo(LPBKPLUGININFO lpPlugInInfo)
{
	/* You MUST specify at least szPlugInName and szVendor.
	   otherwise Becky! will silently ignore your plug-in.*/
	strcpy(lpPlugInInfo->szPlugInName, "Becky! gvcq");
	strcpy(lpPlugInInfo->szVendor, "wagashi");
	strcpy(lpPlugInInfo->szVersion, "1.0");
	strcpy(lpPlugInInfo->szDescription, "LT[õtH_t@C𒼐ڊJ܂");
	// Always return 0.
	return 0;
}

#ifdef __cplusplus
}
#endif
