/*!
******************************************************************************

	@file	vbe_ddc.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __VBE_DDC_H__
#define __VBE_DDC_H__

#pragma pack(1)

typedef union {
	u8		b[128];
	struct {
		u64		header;
		u16		manufacturer_id;
		u16		product_code;
		u32		serial_number;
		u8		week;
		u8		year;
		u8		version;
		u8		revision;
		u8		video_input_def;
		u8		max_horz_img_size;
		u8		max_vert_img_size;
		u8		gamma;
		u8		features;
		u8		green_y_l	: 2;
		u8		green_x_l	: 2;
		u8		red_y_l		: 2;
		u8		red_x_l		: 2;
		u8		white_y_l	: 2;
		u8		white_x_l	: 2;
		u8		blue_y_l	: 2;
		u8		blue_x_l	: 2;
		u8		red_x_h;
		u8		red_y_h;
		u8		green_x_h;
		u8		green_y_h;
		u8		blue_x_h;
		u8		blue_y_h;
		u8		white_x_h;
		u8		white_y_h;
		u8		est_timing[3];
		u16		std_timing[8];
		u8		pref_timing[18];
		u8		detail_info[3][18];
		u8		ext_block_cnt;
		u8		checksum;
	};
} VBE_DDC_EDID;

#pragma pack()

extern bool vbe_ddc_init( void );

#endif // !__VBE_DDC_H__
