/*!
******************************************************************************

	@file	video.h

	Copyright (C) 2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __VIDEO_H__
#define __VIDEO_H__

#define VIDEO_TYPE_UNKNOWN	0
#ifndef _VSUN86_PCSIM
#define VIDEO_TYPE_VBE		1
#define VIDEO_TYPE_AMD		2
#else	//_VSUN86_PCSIM
#define VIDEO_TYPE_SDL		0xFF
#endif	//_VSUN86_PCSIM

typedef struct {
	u16		width;
	u16		height;
	u8		bpp;
	u8		type;
	u32		xbytes;
	void *	fb;
	u32		fbsize;
#ifdef	_VSUN86_PCSIM
	SDL_Surface	*screen;
#endif	//_VSUN86_PCSIM
} VIDEO;

extern const VIDEO * video_init( u16 width, u16 height, u8 bpp );

#endif //!__VIDEO_H__
