/*!
******************************************************************************

	@file	video.cpp

	Copyright (C) 2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/
/*-*- mode: C++; Encoding: utf8n -*-*/

#include "vsun86.h"
#include "printf.h"
#include "video.h"
#ifndef _VSUN86_PCSIM
#include "video/vbe/vbe.h"
#endif	//!_VSUN86_PCSIM

static VIDEO video;

const VIDEO * video_init( u16 width, u16 height, u8 bpp )
{
#ifndef _VSUN86_PCSIM
	if ( vbe_probe( width, height, bpp ) )
	{	// VBEでのモード変更に成功
		video.width	 = width;
		video.height = height;
		video.bpp	 = bpp;
		video.type	 = VIDEO_TYPE_VBE;
		video.xbytes = vbe_mode_info.scan_line_bytes;
		video.fb	 = vbe_mode_info.phys_base;
		video.fbsize = vbe_ctrl_info.total_memory;
		return &video;
	}
	return NULL;
#else	//_VSUN86_PCSIM
	SDL_WM_SetCaption( "Vsun86", NULL );
	video.screen = SDL_SetVideoMode( width, height, bpp, 0 );
	if ( video.screen == NULL )
		return NULL;
	video.width	 = width;
	video.height = height;
	video.bpp	 = bpp;
	video.type	 = VIDEO_TYPE_SDL;
	video.xbytes = video.width * 4;
	video.fb	 = video.screen->pixels;
	video.fbsize = 0;
	return &video;
#endif	//_VSUN86_PCSIM
}
