/*!
******************************************************************************

	@file	hub.h

	Copyright (C) 2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __USB_CLASS_HUB_H__
#define __USB_CLASS_HUB_H__

#pragma pack(1)

#define USB_DT_HUB		0x2900

// Hub Class Request Codes
#define USB_HUB_GET_STATUS				0x00
#define USB_HUB_CLEAR_FEATURE			0x01
#define USB_HUB_SET_FEATURE				0x03
#define USB_HUB_GET_DESCRIPTOR			0x06
#define USB_HUB_SET_DESCRIPTOR			0x07
#define USB_HUB_CLEAR_TT_BUFFER			0x08
#define USB_HUB_RESET_TT				0x09
#define USB_HUB_GET_TT_STATE			0x0A
#define USB_HUB_STOP_TT					0x0B

// Hub Class Feature Selectors
#define USB_HUB_C_LOCAL_POWER			0x00
#define USB_HUB_C_OVER_CURRENT			0x01
#define USB_HUB_PORT_CONNECTION			0x00
#define USB_HUB_PORT_ENABLE				0x01
#define USB_HUB_PORT_SUSPEND			0x02
#define USB_HUB_PORT_OVER_CURRENT		0x03
#define USB_HUB_PORT_RESET				0x04
#define USB_HUB_PORT_POWER				0x08
#define USB_HUB_PORT_LOW_SPEED			0x09
#define USB_HUB_C_PORT_CONNECTION		0x10
#define USB_HUB_C_PORT_ENABLE			0x11
#define USB_HUB_C_PORT_SUSPEND			0x12
#define USB_HUB_C_PORT_OVER_CURRENT		0x13
#define USB_HUB_C_PORT_RESET			0x14
#define USB_HUB_PORT_TEST				0x15
#define USB_HUB_PORT_INDICATOR			0x16

typedef struct {
	u8		bLength;
	u8		bDescriptorType;
	u8		bNbrPorts;
	u16		wHubCharacteristics;
	u8		bPwrOn2PwrGood;
	u8		bHubContrCurrent;
//	u8		DeviceRemovable[1];
//	u8		PortPwrCtrlMask[1];
} USB_HUB_DESC;

#define USB_HUB_PORTST_CONNECTION		(1 <<  0)
#define USB_HUB_PORTST_ENABLE			(1 <<  1)
#define USB_HUB_PORTST_SUSPEND			(1 <<  2)
#define USB_HUB_PORTST_OVER_CURRENT		(1 <<  3)
#define USB_HUB_PORTST_RESET			(1 <<  4)
#define USB_HUB_PORTST_POWER			(1 <<  8)
#define USB_HUB_PORTST_LOW_SPEED		(1 <<  9)
#define USB_HUB_PORTST_HIGH_SPEED		(1 << 10)
#define USB_HUB_PORTST_TEST				(1 << 11)
#define USB_HUB_PORTST_INDICATOR		(1 << 12)
#define USB_HUB_PORTST_C_CONNECTION		(1 << 16)
#define USB_HUB_PORTST_C_ENABLE			(1 << 17)
#define USB_HUB_PORTST_C_SUSPEND		(1 << 18)
#define USB_HUB_PORTST_C_OVER_CURRENT	(1 << 19)
#define USB_HUB_PORTST_C_PORT_RESET		(1 << 20)

#pragma pack()

extern bool usb_hub_init( USB_DEVICE *dev, USB_HCD *child_hcd );

#endif // ! __USB_CLASS_HUB_H__
