/*!
******************************************************************************

	@file	hid.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "usb.h"
#include "hid.h"
#include "timer.h"
#include "printf.h"
#include "keyboard.h"

#define USB_HID_CMD_TIMEOUT		5000	// [ms]

//static bool usb_hid_get_descriptor( USB_DEVICE *, u16, u16, void *, size_t );
static bool usb_hid_get_idle( USB_DEVICE *, u8, u16, u8 * );
static bool usb_hid_set_idle( USB_DEVICE *, u8, u16, u8 );

static bool usb_hid_kbd_read( void *, KEY_CODES * );

bool usb_hid_init( USB_DEVICE *dev )
{
	int int_in = -1;
	for ( int i=0; i<USB_ENDPOINT_MAX; i++ )
	{	// Interrupt-In エンドポイントを取得する
		if ( !dev->ep[i].valid )
			continue;
		if ( USB_ENDPT_XFER_TYPE( dev->ep[i].attr ) != USB_ENDPT_INT )
			continue;
		if ( dev->ep[i].addr & 0x80 )
		{	// Interrupt-In
			if ( int_in < 0 ) {
				int_in = i;
				break;
			}
		}
	}
	if ( int_in < 0 )
	{	// エンドポイントが見つからない
		vmm_printf( VMM_DEBUG, "usb_hid: cannot found endpoint.\n" );
		return false;
	}
	dev->hid.int_in = int_in;

	u8 idle_rate;
	if ( !usb_hid_get_idle( dev, 0, dev->iface_number, &idle_rate ) ) {
		vmm_printf( VMM_DEBUG, "usb_hid: GET_IDLE failed.\n" );
		return false;
	}
//	vmm_printf( VMM_DEBUG, "Idle rate = %02x (%d ms)\n", idle_rate, idle_rate << 2 );
	idle_rate = 4;	// 16ms
	if ( !usb_hid_set_idle( dev, 0, dev->iface_number, idle_rate ) ) {
		vmm_printf( VMM_DEBUG, "usb_hid: SET_IDLE failed.\n" );
		return false;
	}

	/*
	u8 buf[256];
	const u8 size = dev->ep[int_in].max_pkt_size;
	for ( int i=0; i<100; i++ ) {
		if ( dev->hcd.int_read( dev, dev->ep[int_in].addr, buf, size, 1000 ) ) {
			for ( u8 i=0; i<size; i++ )
				vmm_printf( VMM_DEBUG, "%02x ", buf[i] );
			vmm_printf( VMM_DEBUG, "\n" );
		}
		sleep( 10 );
	}
	*/
	switch ( dev->iface_protocol )
	{
	case USB_HID_KEYBOARD:
		{	// キーボードを登録する
			KEYBOARD_OPS ops;
			ops.read = usb_hid_kbd_read;
			if ( !keyboard_register( dev, &ops ) ) {
				vmm_printf( VMM_DEBUG, "usb_hid: keyboard_register() failed.\n" );
				return false;
			}
			/*
			KEY_CODES codes;
			for ( int i=0; i<100; i++ ) {
				if ( keyboard_read( &codes ) ) {
					for ( u8 i=0; i<codes.num; i++ )
						vmm_printf( VMM_DEBUG, "%08x ", codes.code[i] );
				}
				vmm_printf( VMM_DEBUG, "\n" );
				sleep( 10 );
			}
			*/
		}
		break;
	}

	return true;
}

/*
static bool usb_hid_get_descriptor( USB_DEVICE *dev, u16 type, u16 iface, void *desc, size_t size )
{
	return usb_ctrl_msg( dev, USB_REQ_DIR_IN | USB_REQ_TYPE_STD | USB_REQ_INTERFACE,
						 USB_GET_DESCRIPTOR, type, iface, desc, size, USB_HID_CMD_TIMEOUT );
}
*/

static bool usb_hid_get_idle( USB_DEVICE *dev, u8 report_id, u16 iface, u8 *idle_rate )
{
	return usb_ctrl_msg( dev, USB_REQ_DIR_IN | USB_REQ_TYPE_CLASS | USB_REQ_INTERFACE,
						 USB_HID_GET_IDLE, report_id, iface, idle_rate, 1, USB_HID_CMD_TIMEOUT );
}

static bool usb_hid_set_idle( USB_DEVICE *dev, u8 report_id, u16 iface, u8 idle_rate )
{
	return usb_ctrl_msg( dev, USB_REQ_DIR_OUT | USB_REQ_TYPE_CLASS | USB_REQ_INTERFACE,
						 USB_HID_SET_IDLE, (idle_rate << 8) | report_id, iface, NULL, 0, USB_HID_CMD_TIMEOUT );
}

// HID Keyboard/Keypad の UsageID から OADG109A のキー番号に変換
// [参考] http://www2d.biglobe.ne.jp/~msyk/keyboard/layout/usbkeycode.html
static u8 usb_hid_key_oadg[256] =
{	//	 +0  +1  +2  +3  +4  +5  +6  +7  +8  +9  +A  +B  +C  +D  +E  +F
		  0,  0,  0,  0, 31, 50, 48, 33, 19, 34, 35, 36, 24, 37, 38, 39,
		 52, 51, 25, 26, 17, 20, 32, 21, 23, 49, 18, 47, 22, 46,  2,  3,
		  4,  5,  6,  7,  8,  9, 10, 11, 43,110, 15, 16, 61, 12, 13, 27,
		 28, 29, 42, 40, 41,  1, 53, 54, 55, 30,112,113,114,115,116,117,
		118,119,120,121,122,123,124,125,126, 75, 80, 85, 76, 81, 86, 89,
		 79, 84, 83, 90, 95,100,105,106,108, 93, 98,103, 92, 97,102, 91,
		 96,101, 99,104, 45,129,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		  0,  0,  0,  0,  0,107,  0, 56,133, 14,132,131,  0,  0,  0,  0,
		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
};

static bool usb_hid_kbd_read( void *p, KEY_CODES *codes )
{
	USB_DEVICE *dev = (USB_DEVICE *)p;

	u8 buf[8];
	if ( !usb_interrupt_read( dev, dev->hid.int_in, buf, sizeof(buf), 1000 ) )
		return false;

//	for ( u8 i=0; i<8; i++ )
//		vmm_printf( VMM_DEBUG, "%02x ", buf[i] );
//	vmm_printf( VMM_DEBUG, "\n" );

	u8 num = 0;
	codes->mod = buf[0];
	for ( u8 i=2; i<8; i++ ) {
		if ( buf[i] < 0x04 )
			break;
		codes->key[num] = usb_hid_key_oadg[buf[i]];
		num++;
	}
	codes->num = num;

	/*
	if ( codes->num > 0 ) {
		for ( u8 i=0; i<codes->num; i++ )
			vmm_printf( VMM_DEBUG, "%08x ", codes->code[i] );
		vmm_printf( VMM_DEBUG, "\n" );
	}
	*/

	return true;
}
