/*!
******************************************************************************

	@file	vminit.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "shell.h"
#include "fs.h"
#include "pfemu.h"

#include <stdio.h>

static void usage( void )
{
	printf( "Usage: vminit [vm_name]\n" );
}

void shell_cmd_vminit( const char *vm_name )
{
	const char *filename = NULL;

	if ( (vm_name == NULL) || (vm_name[0] == '\0') ) {
		usage();
		return;
	}

	if ( 0 == strcmp( vm_name, "nec98" ) )
		filename = "//0/VM98X1.BIN";
	else {
		usage();
		return;
	}

	puts( "Loading VM module ... " );
	int fd = fs_open( filename );
	if ( fd == FS_FILE_DESC_INVALID ) {
		puts( "failed. (cannot open file)\n" );
		return;
	}
	size_t filesize;
	if ( !fs_get_file_size( fd, &filesize ) ) {
		puts( "failed. (cannot get file size)\n" );
		return;
	}
	if ( filesize > VM_MODULE_SIZE ) {
		puts( "failed. (module size too large)\n" );
		return;
	}
	if ( !fs_read( fd, VM_MODULE, filesize ) ) {
		puts( "failed. (read error)\n" );
		return;
	}
	fs_close( fd );
	printf( "OK. (%d bytes)\n", filesize );
}
