/*!
******************************************************************************

	@file	pic.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __PIC_H__
#define __PIC_H__

#include "common.h"

// Master (IRQ0-7)
#define PIC_MASTER		0
#define IO_PIC0_IRR		0x20	// R
#define IO_PIC0_ISR		0x20	// R
#define IO_PIC0_OCW2	0x20	// W
#define IO_PIC0_OCW3	0x20	// W
#define IO_PIC0_ICW1	0x20	// W
#define IO_PIC0_IMR		0x21	// R
#define IO_PIC0_OCW1	0x21	// W
#define IO_PIC0_ICW2	0x21	// W
#define IO_PIC0_ICW3	0x21	// W
#define IO_PIC0_ICW4	0x21	// W

// Slave (IRQ8-15)
#define PIC_SLAVE		0x80
#define IO_PIC1_IRR		0xA0	// R
#define IO_PIC1_ISR		0xA0	// R
#define IO_PIC1_OCW2	0xA0	// W
#define IO_PIC1_OCW3	0xA0	// W
#define IO_PIC1_ICW1	0xA0	// W
#define IO_PIC1_IMR		0xA1	// R
#define IO_PIC1_OCW1	0xA1	// W
#define IO_PIC1_ICW2	0xA1	// W
#define IO_PIC1_ICW3	0xA1	// W
#define IO_PIC1_ICW4	0xA1	// W

extern bool pic_init( void );
extern void pic_enable_irq( u8 irq );
extern void pic_disable_irq( u8 irq );
extern void pic_send_eoi( u8 irq );
extern u8 pic_get_imr( u8 index );
extern u8 pic_get_irr( u8 index );
extern u8 pic_get_isr( u8 index );

#ifdef	_VSUN86_PCSIM
extern int pic_set_irq( u8 irq );
#endif	//_VSUN86_PCSIM

#endif // !__PIC_H__
