/*!
******************************************************************************

	@file	softemu.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __SOFTEMU_H__
#define __SOFTEMU_H__

#pragma pack(1)

#define OP_CODE_INVALID		0xFFFFFFFF

#define OP_PREFIX_CODE32	0x00010000
#define OP_PREFIX_ADDR32	0x00020000
#define OP_PREFIX_REPNE		0x00040000
#define OP_PREFIX_REPE		0x00080000
#define OP_PREFIX_REP		OP_PREFIX_REPE
#define OP_PREFIX_SEG_SHIFT	20
#define OP_PREFIX_SEG_MASK	(0x07 << OP_PREFIX_SEG_SHIFT)
#define OP_PREFIX_SEG(info)	((info) & OP_PREFIX_SEG_MASK)
#define OP_PREFIX_SEG_NONE	VCPU_SEG_INDEX_NULL
#define OP_PREFIX_SEG_ES	(VCPU_SEG_INDEX_ES << OP_PREFIX_SEG_SHIFT)
#define OP_PREFIX_SEG_CS	(VCPU_SEG_INDEX_CS << OP_PREFIX_SEG_SHIFT)
#define OP_PREFIX_SEG_SS	(VCPU_SEG_INDEX_SS << OP_PREFIX_SEG_SHIFT)
#define OP_PREFIX_SEG_DS	(VCPU_SEG_INDEX_DS << OP_PREFIX_SEG_SHIFT)
#define OP_PREFIX_SEG_FS	(VCPU_SEG_INDEX_FS << OP_PREFIX_SEG_SHIFT)
#define OP_PREFIX_SEG_GS	(VCPU_SEG_INDEX_GS << OP_PREFIX_SEG_SHIFT)
#define OP_PREFIX_2BYTES	0x00800000
#define OP_USE_MODRM		0x00008000
#define OP_USE_8BIT_REG		0x00004000
#define OP_CODE_SHIFT		24
#define OP_CODE(info)		(u8)((info) >> OP_CODE_SHIFT)
#define OP_BYTES_MASK		0xFF
#define OP_BYTES(info)		(u8)((info) & OP_BYTES_MASK)

typedef struct {
	u8				bytes;
	u8				reg_index;
	u8				rm_index;
	u8				rsvd;
	void *			reg;
	void *			rm_reg;
	SVM_VMCB_SEG *	rm_seg;
	u32				rm_off;
} MODRM_INFO;

#define MODRM_RM_MEM	0xFF

#pragma pack()

extern bool vcpu_emulate( VCPU *cpu, u8 *mem );
extern bool vcpu_intercept_read_cr( VCPU *cpu, u8 *mem );
extern bool vcpu_analyze_modrm( VCPU *cpu, u8 *mem, u32 op_info, MODRM_INFO *modrm );

// mov.cpp
extern bool vcpu_emulate_mov_modrm( VCPU *cpu, u8 *mem, u32 op_info );
extern bool vcpu_emulate_mov_moffs( VCPU *cpu, u8 *mem, u32 op_info );

// movs.cpp
extern bool vcpu_emulate_movs( VCPU *cpu, u8 *mem, u32 op_info );

// stos.cpp
extern bool vcpu_emulate_stos( VCPU *cpu, u8 *mem, u32 op_info );

// xchg.cpp
extern bool vcpu_emulate_xchg( VCPU *cpu, u8 *mem, u32 op_info );

#endif // !__SOFTEMU_H__
