/*!
******************************************************************************

	@file	msr.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __MSR_H__
#define __MSR_H__

#include "common.h"

#define rdmsr( msr ) 											\
({																\
	u64 _value;													\
	__asm__ __volatile__( "rdmsr" : "=A"(_value) : "c"(msr) );	\
	_value;														\
})

#define wrmsr( msr, value )												\
({																		\
	__asm__ __volatile__( "wrmsr" : : "c"(msr), "A"((u64)(value)) );	\
})

#define MSR_APIC_BASE			0x0000001B
#define MSR_MTRRcap				0x000000FE
#define MSR_SYSENTER_CS			0x00000174
#define MSR_SYSENTER_ESP		0x00000175
#define MSR_SYSENTER_EIP		0x00000176
#define MSR_MTRRphysBase(n)		(0x00000200 + ((n)<<1))
#define MSR_MTRRphysMask(n)		(0x00000201 + ((n)<<1))
#define MSR_MTRRfix64K_00000	0x00000250
#define MSR_MTRRfix16K_80000	0x00000258
#define MSR_MTRRfix16K_A0000	0x00000259
#define MSR_MTRRfix4K_C0000		0x00000268
#define MSR_MTRRfix4K_C8000		0x00000269
#define MSR_MTRRfix4K_D0000		0x0000026A
#define MSR_MTRRfix4K_D8000		0x0000026B
#define MSR_MTRRfix4K_E0000		0x0000026C
#define MSR_MTRRfix4K_E8000		0x0000026D
#define MSR_MTRRfix4K_F0000		0x0000026E
#define MSR_MTRRfix4K_F8000		0x0000026F
#define MSR_PAT					0x00000277
#define MSR_MTRRdefType			0x000002FF
#define MSR_EFER				0xC0000080
#define MSR_STAR				0xC0000081
#define MSR_LSTAR				0xC0000082
#define MSR_CSTAR				0xC0000083
#define MSR_FMASK				0xC0000084
#define MSR_KERNEL_GS_BASE		0xC0000102
#define MSR_VM_CR				0xC0010114
#define MSR_VM_HSAVE_PA			0xC0010117

// APIC_BASE
#define APIC_BASE_AE			0x00000800
#define APIC_BASE_BSC			0x00000100

// MTRRcap
#define MTRRcap_VCNT_MASK		0x000000FF
#define MTRRcap_FIX				0x00000100
#define MTRRcap_WC				0x00000400

// MTRRphysBase
#define MTRRphysBase_Type_MASK	0x000000FF

// MTRRphysMask
#define MTRRphysMask_V			0x00000800

// EFER
#define EFER_SVME				0x00001000

// VM_CR
#define VM_CR_DPD				0x00000001
#define VM_CR_R_INIT			0x00000002
#define VM_CR_DIS_A20M			0x00000004
#define VM_CR_LOCK				0x00000008
#define VM_CR_SVMDIS			0x00000010

#endif // __MSR_H__
