/*!
******************************************************************************

	@file	irq.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __IRQ_H__
#define __IRQ_H__

typedef bool (CALLBACK *IRQ_HANDLER)( u8, void * );

typedef enum {
	IRQ_TRIGGER_EDGE,
	IRQ_TRIGGER_LEVEL
} IRQ_TRIGGER;

typedef struct {
	IRQ_TRIGGER	trigger;
	IRQ_HANDLER	proc;
	void *		args;
} IRQ_INFO;

#define IRQ_TIMER			0
#define IRQ_KEYBOARD		1
#define IRQ_CASCADE			2
#define IRQ_COM2			3
#define IRQ_COM1			4
#define IRQ_FDC				6
#define IRQ_LPT1			7
#define IRQ_RTC				8
#define IRQ_MOUSE			12
#define IRQ_ATA0			14
#define IRQ_ATA1			15
#define IRQ_MAX				15
#define IRQ_NUM_MAX			16

#define IRQ_LEVEL_ENTRY_MAX	16

EXTERN_C void CALLBACK irq_handler( u8 n );

extern void irq_init( void );
extern bool irq_register( u8 n, IRQ_TRIGGER trigger, IRQ_HANDLER proc, void *args );
extern void irq_unregister( u8 n, IRQ_HANDLER proc );
//extern void irq_lock( void );
//extern void irq_unlock( void );

#endif // !__IRQ_H__
