/*!
******************************************************************************

	@file	fat.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __FAT_H__
#define __FAT_H__

#pragma pack(1)

typedef struct {
	u8		jmp[3];			// +00h : near jmp命令
	u8		oem_name[8];	// +03h : メーカ名
	u16		bysec;			// +0Bh : 1レコードのバイト数(2の倍数)
	u8		sclus;			// +0Dh : 1クラスタのレコード数
	u16		rsvd_sec;		// +0Eh : 予約のレコード数
	u8		numFAT;			// +10h : FATの数
	u16		numDIR;			// +11h : ルートディレクトリ総エントリ数(32の倍数)
	u16		totalsec16;		// +13h : レコード総数
	u8		media;			// +15h : メディアディスクリプタ
	u16		sFAT;			// +16h : 1FATのレコード数
	u16		strack;			// +18h : 1トラックのセクタ数
	u16		numhead;		// +1Ah : ヘッド数
	u32		hiddensec;		// +1Ch : 隠れたレコード数
	u32		totalsec32;		// +20h : 論理イメージのレコード総数
	u8		pdrv;			// +24h : 物理ドライブ番号
	u8		rsvd;			// +25h : 予約領域
	u8		boot_sig;		// +26h : 拡張ブートレコード識別コード
	u32		vol_serial;		// +27h : ボリュームシリアル番号
	char	vol_label[11];	// +2Bh : ボリュームラベル
	char	fs_type[8];		// +36h : ファイルシステムタイプ
} FAT_BPB;

typedef struct {
	char	name[11];
	u8		attr;
	u8		rsvd;
	u8		create_time_ms;
	u16		create_time;
	u16		create_date;
	u16		access_date;
	u16		clus_high_word;
	u16		update_time;
	u16		update_date;
	u16		clus_low_word;
	u32		file_size;
} FAT_RDE;

#define FAT_ATTR_READ_ONLY	0x01
#define FAT_ATTR_HIDDEN		0x02
#define FAT_ATTR_SYSTEM		0x04
#define FAT_ATTR_VOLUME_ID	0x08
#define FAT_ATTR_DIRECTORY	0x10
#define FAT_ATTR_ARCHIVE	0x20
#define FAT_ATTR_LONG_NAME	(FAT_ATTR_READ_ONLY | FAT_ATTR_HIDDEN | FAT_ATTR_SYSTEM | FAT_ATTR_VOLUME_ID)

typedef struct {
	FAT_BPB		bpb;
	FAT_RDE		rde[512];
	union {
		u8		fat12[512*3];
		u16		fat16[256];
	};
	u32			fat_page;
	u32			first_data_sec;
	u32			clus;
	u8			clus_data[65536];
} FAT_CACHE;

#pragma pack()

extern bool fat_init( FS_OPS *ops );

#endif //!__FAT_H__
