/*!
******************************************************************************

	@file	fs.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __FS_H__
#define __FS_H__

#pragma pack(1)

typedef struct {
	u32		disk_id;
	bool	valid;
	u8		fs_ops_id;
	u8		fs_type;
	u8		rsvd;
	u32		first_sec;
	void *	cache;
	u32		cache_size;
} FS_DRIVE;

#define FS_DRIVE_MAX	4
#define FS_FNAME_MAX	260

typedef struct {
	u32		drive_id;
	char	name[FS_FNAME_MAX];
	u32		size;
	long	rp;
	u32		clus_1st;
	u32		clus_cur;
} FS_FILE;

#define FS_FILE_DESC_MAX		64
#define FS_FILE_DESC_INVALID	(-1)

typedef struct {
	u8		fs_id;
	u8		rsvd[3];
	bool	( *probe )( FS_DRIVE * );
	bool	( *open  )( FS_DRIVE *, FS_FILE * );
	bool	( *read  )( FS_DRIVE *, FS_FILE *, void *, size_t );
	bool	( *seek  )( FS_DRIVE *, FS_FILE *, long, int );
} FS_OPS;

#define FS_SEEK_SET		0
#define FS_SEEK_CUR		1
#define FS_SEEK_END		2

#define FS_OPS_UNKNOWN	0
#define FS_OPS_FAT		1
#define FS_OPS_MAX		2

typedef struct {
	u8		bootstrap[510];
	u8		sig[2];
} VBR;

typedef struct {
	u8		bootstrap[446];
	struct PACKED {
		u8		boot_desc;
		u8		first_part_sec[3];
		u8		fs_desc;
		u8		last_part_sec[3];
		u32		first_sec;
		u32		num_sectors;
	} partition[4];
	u8		sig[2];
} MBR;

#define FS_UNKNOWN		0x00
#define FS_FAT12		0x01
#define FS_FAT16_OLD	0x04
#define FS_EXT_DOS		0x05
#define FS_FAT16		0x06
#define FS_FAT32		0x0B
#define FS_FAT32_EXT	0x0C
#define FS_FAT16_EXT	0x0E
#define FS_EXT_DOS_EXT	0x0F

#define FS_1ST_SECTOR_VBR	0x01
#define FS_1ST_SECTOR_MBR	0x02

#pragma pack()

extern bool fs_init( void );
extern bool fs_probe( u32 disk_id, u8 first_sector_type );
extern int  fs_open( const char *filename );
extern bool fs_close( int fd );
extern bool fs_read( int fd, void *buf, size_t buf_size );
extern long fs_seek( int fd, long ptr, int method );
extern bool fs_get_file_size( int fd, size_t *file_size );

#endif // !__FS_H__
