/*!
******************************************************************************

	@file	font.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "font.h"
#include "fs.h"
#include "printf.h"

#ifdef	_VSUN86_PCSIM
#include <stdio.h>
#endif	//_VSUN86_PCSIM

#define FONT_ROM		font_rom
#define FONT_ROM_SIZE	0x80000
static u8 font_rom[FONT_ROM_SIZE];

#define FONT_ROM_OFFSET_8x8		0x0000
#define FONT_ROM_OFFSET_8x16	0x0800
#define FONT_ROM_OFFSET_16x16	0x1800

static u8 font_default[] = {
	/* ' ' */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* '!' */ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* '"' */ 0x00, 0x6C, 0x6C, 0x24, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* '#' */ 0x00, 0x44, 0x44, 0xFE, 0x44, 0x44, 0x44, 0x44, 0x44, 0xFE, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00,
	/* '$' */ 0x00, 0x10, 0x7C, 0x92, 0x90, 0x90, 0x7C, 0x12, 0x12, 0x92, 0x7C, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* '%' */ 0x00, 0x40, 0xA0, 0xA2, 0xA4, 0x48, 0x10, 0x24, 0x4A, 0x8A, 0x0A, 0x04, 0x00, 0x00, 0x00, 0x00,
	/* '&' */ 0x00, 0x70, 0x88, 0x88, 0x88, 0x50, 0x60, 0xA0, 0x92, 0x8A, 0x84, 0x7A, 0x00, 0x00, 0x00, 0x00,
	/* ''' */ 0x00, 0x30, 0x30, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* '(' */ 0x00, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00,
	/* ')' */ 0x00, 0x40, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00,
	/* '*' */ 0x00, 0x00, 0x10, 0x92, 0x54, 0x38, 0x10, 0x38, 0x54, 0x92, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* '+' */ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0xFE, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ',' */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x10, 0x20, 0x00, 0x00,
	/* '-' */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* '.' */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
	/* '/' */ 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* '0' */ 0x00, 0x38, 0x44, 0x86, 0x8A, 0x8A, 0x92, 0xA2, 0xA2, 0xC2, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* '1' */ 0x00, 0x10, 0x30, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7C, 0x00, 0x00, 0x00, 0x00,
	/* '2' */ 0x00, 0x38, 0x44, 0x82, 0x82, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0xFE, 0x00, 0x00, 0x00, 0x00,
	/* '3' */ 0x00, 0x38, 0x44, 0x82, 0x02, 0x04, 0x38, 0x04, 0x02, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* '4' */ 0x00, 0x08, 0x18, 0x18, 0x28, 0x28, 0x48, 0x48, 0x88, 0xFE, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
	/* '5' */ 0x00, 0xFC, 0x80, 0x80, 0x80, 0xB8, 0xC4, 0x82, 0x02, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* '6' */ 0x00, 0x38, 0x44, 0x82, 0x80, 0xB8, 0xC4, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* '7' */ 0x00, 0xFE, 0x82, 0x82, 0x82, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* '8' */ 0x00, 0x38, 0x44, 0x82, 0x82, 0x44, 0x38, 0x44, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* '9' */ 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x46, 0x3A, 0x02, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* ':' */ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ';' */ 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00,
	/* '<' */ 0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00,
	/* '=' */ 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* '>' */ 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00,
	/* '?' */ 0x00, 0x38, 0x44, 0x82, 0x82, 0x04, 0x08, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* '@' */ 0x00, 0x38, 0x44, 0x82, 0x9A, 0xAA, 0xAA, 0xAA, 0xBC, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* 'A' */ 0x00, 0x10, 0x28, 0x44, 0x82, 0x82, 0x82, 0xFE, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00,
	/* 'B' */ 0x00, 0xF8, 0x84, 0x82, 0x82, 0x84, 0xF8, 0x84, 0x82, 0x82, 0x84, 0xF8, 0x00, 0x00, 0x00, 0x00,
	/* 'C' */ 0x00, 0x38, 0x44, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* 'D' */ 0x00, 0xF8, 0x84, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x84, 0xF8, 0x00, 0x00, 0x00, 0x00,
	/* 'E' */ 0x00, 0xFE, 0x80, 0x80, 0x80, 0x80, 0xFC, 0x80, 0x80, 0x80, 0x80, 0xFE, 0x00, 0x00, 0x00, 0x00,
	/* 'F' */ 0x00, 0xFE, 0x80, 0x80, 0x80, 0x80, 0xFC, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
	/* 'G' */ 0x00, 0x38, 0x44, 0x82, 0x80, 0x80, 0x8E, 0x82, 0x82, 0x82, 0x46, 0x3A, 0x00, 0x00, 0x00, 0x00,
	/* 'H' */ 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0xFE, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00,
	/* 'I' */ 0x00, 0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7C, 0x00, 0x00, 0x00, 0x00,
	/* 'J' */ 0x00, 0x3E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x84, 0x84, 0x48, 0x30, 0x00, 0x00, 0x00, 0x00,
	/* 'K' */ 0x00, 0x82, 0x84, 0x88, 0x90, 0xA0, 0xC0, 0xA0, 0x90, 0x88, 0x84, 0x82, 0x00, 0x00, 0x00, 0x00,
	/* 'L' */ 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xFE, 0x00, 0x00, 0x00, 0x00,
	/* 'M' */ 0x00, 0x82, 0xC6, 0xC6, 0xAA, 0xAA, 0x92, 0x92, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00,
	/* 'N' */ 0x00, 0x82, 0xC2, 0xC2, 0xA2, 0xA2, 0x92, 0x8A, 0x8A, 0x86, 0x86, 0x82, 0x00, 0x00, 0x00, 0x00,
	/* 'O' */ 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* 'P' */ 0x00, 0xF8, 0x84, 0x82, 0x82, 0x84, 0xF8, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
	/* 'Q' */ 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x9A, 0xA6, 0x64, 0x3A, 0x00, 0x00, 0x00, 0x00,
	/* 'R' */ 0x00, 0xF8, 0x84, 0x82, 0x82, 0x84, 0xF8, 0x90, 0x88, 0x84, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00,
	/* 'S' */ 0x00, 0x38, 0x44, 0x82, 0x80, 0x40, 0x38, 0x04, 0x02, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* 'T' */ 0x00, 0xFE, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* 'U' */ 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	/* 'V' */ 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* 'W' */ 0x00, 0x82, 0x82, 0x82, 0x82, 0x92, 0x92, 0xAA, 0xAA, 0xC6, 0xC6, 0x82, 0x00, 0x00, 0x00, 0x00,
	/* 'X' */ 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00,
	/* 'Y' */ 0x00, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* 'Z' */ 0x00, 0xFE, 0x02, 0x02, 0x04, 0x28, 0x10, 0x28, 0x40, 0x80, 0x80, 0xFE, 0x00, 0x00, 0x00, 0x00,
	/* '[' */ 0x00, 0x1C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1C, 0x00, 0x00, 0x00, 0x00,
	/* '\' */ 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ']' */ 0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x70, 0x00, 0x00, 0x00, 0x00,
	/* '^' */ 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* '_' */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00,
	/* '`' */ 0x00, 0x30, 0x38, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* 'a' */ 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x04, 0x7C, 0x84, 0x84, 0x8C, 0x74, 0x00, 0x00, 0x00, 0x00,
	/* 'b' */ 0x00, 0x80, 0x80, 0x80, 0xB0, 0xC8, 0x84, 0x84, 0x84, 0x84, 0xC8, 0xB0, 0x00, 0x00, 0x00, 0x00,
	/* 'c' */ 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x80, 0x80, 0x80, 0x80, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00,
	/* 'd' */ 0x00, 0x04, 0x04, 0x04, 0x34, 0x4C, 0x84, 0x84, 0x84, 0x84, 0x4C, 0x34, 0x00, 0x00, 0x00, 0x00,
	/* 'e' */ 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x84, 0xFC, 0x80, 0x80, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00,
	/* 'f' */ 0x00, 0x0C, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* 'g' */ 0x00, 0x00, 0x00, 0x00, 0x34, 0x4C, 0x84, 0x84, 0x84, 0x84, 0x4C, 0x34, 0x84, 0x48, 0x30, 0x00,
	/* 'h' */ 0x00, 0x80, 0x80, 0x80, 0xB0, 0xC8, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x00, 0x00, 0x00, 0x00,
	/* 'i' */ 0x00, 0x10, 0x10, 0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7C, 0x00, 0x00, 0x00, 0x00,
	/* 'j' */ 0x00, 0x08, 0x08, 0x00, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x30, 0x00,
	/* 'k' */ 0x00, 0x80, 0x80, 0x80, 0x80, 0x84, 0x88, 0x90, 0xA0, 0xD0, 0x88, 0x84, 0x00, 0x00, 0x00, 0x00,
	/* 'l' */ 0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* 'm' */ 0x00, 0x00, 0x00, 0x00, 0xEC, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00,
	/* 'n' */ 0x00, 0x00, 0x00, 0x00, 0xF8, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x00, 0x00, 0x00, 0x00,
	/* 'o' */ 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00,
	/* 'p' */ 0x00, 0x00, 0x00, 0x00, 0xB0, 0xC8, 0x84, 0x84, 0x84, 0x84, 0xC8, 0xB0, 0x80, 0x80, 0x80, 0x00,
	/* 'q' */ 0x00, 0x00, 0x00, 0x00, 0x34, 0x4C, 0x84, 0x84, 0x84, 0x84, 0x4C, 0x34, 0x04, 0x04, 0x04, 0x00,
	/* 'r' */ 0x00, 0x00, 0x00, 0x00, 0xB8, 0xC4, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00,
	/* 's' */ 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x80, 0x78, 0x04, 0x04, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00,
	/* 't' */ 0x00, 0x00, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0C, 0x00, 0x00, 0x00, 0x00,
	/* 'u' */ 0x00, 0x00, 0x00, 0x00, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x7C, 0x00, 0x00, 0x00, 0x00,
	/* 'v' */ 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* 'w' */ 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0xAA, 0xAA, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00,
	/* 'x' */ 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00,
	/* 'y' */ 0x00, 0x00, 0x00, 0x00, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x4C, 0x34, 0x84, 0x48, 0x30, 0x00,
	/* 'z' */ 0x00, 0x00, 0x00, 0x00, 0xFE, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0xFE, 0x00, 0x00, 0x00, 0x00,
	/* '{' */ 0x00, 0x0C, 0x10, 0x10, 0x10, 0x10, 0x20, 0x10, 0x10, 0x10, 0x10, 0x0C, 0x00, 0x00, 0x00, 0x00,
	/* '|' */ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	/* '}' */ 0x00, 0x60, 0x10, 0x10, 0x10, 0x10, 0x08, 0x10, 0x10, 0x10, 0x10, 0x60, 0x00, 0x00, 0x00, 0x00,
	/* '~' */ 0x00, 0x62, 0x92, 0x8C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

bool font_init( void )
{
	memcpy( &FONT_ROM[FONT_ROM_OFFSET_8x16 + (' ' << 4)], font_default, sizeof(font_default) );
	return true;
}

bool font_load( const char *filename )
{
#ifndef _VSUN86_PCSIM
	int fd = fs_open( filename );

	size_t font_size;
	if ( !fs_get_file_size( fd, &font_size ) )
		return false;
	vmm_printf( VMM_INFO, "\n" );
	vmm_printf( VMM_INFO, "Loading FONT.ROM ... " );

	if ( !fs_read( fd, FONT_ROM, font_size ) ) {
		vmm_printf( VMM_ERROR, "failed.\n" );
		return false;
	}
	vmm_printf( VMM_INFO, "OK.\n" );

	if ( !fs_close( fd ) )
		return false;
#else	//_VSUN86_PCSIM
	FILE *fp = fopen( &filename[4], "rb" );
	if ( fp == NULL )
		return false;
	vmm_printf( VMM_INFO, "\n" );
	vmm_printf( VMM_INFO, "Loading FONT.ROM ... " );
	fread( font_rom, 1, FONT_ROM_SIZE, fp );
	fclose( fp );
	vmm_printf( VMM_INFO, "OK.\n" );
#endif	//_VSUN86_PCSIM

	return true;
}

const void * font_get_glyph( int c, int *width, int *height )
{
	if ( c < 0x100 )
	{	// 1バイト文字
		*width  = 8;
		*height = 16;
		return &FONT_ROM[FONT_ROM_OFFSET_8x16 + (c << 4)];
	}

	*width  = 16;
	*height = 16;

	u8 jis1 = (u8)(c >> 8);
	u8 jis2 = (u8)(c & 0xFF);
	if ( (jis1 < 0x21) || (jis1 > 0x7C) ||
		 (jis2 < 0x20) || (jis2 > 0x7F) )
		return &FONT_ROM[FONT_ROM_OFFSET_16x16];	// 空白

	jis1 -= 0x21;
	jis2 -= 0x20;
	return &FONT_ROM[FONT_ROM_OFFSET_16x16 + ((jis1 * 0x60 + jis2) << 5)];

}
