/*!
******************************************************************************

	@file	dmac.h

	Copyright (C) 2008 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __DMAC_H__
#define __DMAC_H__

#define IO_DMAC_CH0_ADDR		0x0000
#define IO_DMAC_CH0_CNT			0x0001
#define IO_DMAC_CH1_ADDR		0x0002
#define IO_DMAC_CH1_CNT			0x0003
#define IO_DMAC_CH2_ADDR		0x0004
#define IO_DMAC_CH2_CNT			0x0005
#define IO_DMAC_CH3_ADDR		0x0006
#define IO_DMAC_CH3_CNT			0x0007
#define IO_DMAC0_STATUS			0x0008
#define IO_DMAC0_CMD			0x0008
#define IO_DMAC0_REQ			0x0009
#define IO_DMAC0_MASK			0x000A
#define IO_DMAC0_MODE			0x000B
#define IO_DMAC0_CLR_FF			0x000C
#define IO_DMAC0_TMP			0x000D
#define IO_DMAC0_MASTER_CLR		0x000D
#define IO_DMAC0_CLR_MASK		0x000E
#define IO_DMAC0_ALL_MASK		0x000F

#define IO_DMAC_CH2_PAGE		0x0081
#define IO_DMAC_CH3_PAGE		0x0082
#define IO_DMAC_CH1_PAGE		0x0083
#define IO_DMAC_CH0_PAGE		0x0087
#define IO_DMAC_CH6_PAGE		0x0089
#define IO_DMAC_CH7_PAGE		0x008A
#define IO_DMAC_CH5_PAGE		0x008B
#define IO_DMAC_CH4_PAGE		0x008F

#define IO_DMAC_CH4_ADDR		0x00C0
#define IO_DMAC_CH4_CNT			0x00C2
#define IO_DMAC_CH5_ADDR		0x00C4
#define IO_DMAC_CH5_CNT			0x00C6
#define IO_DMAC_CH6_ADDR		0x00C8
#define IO_DMAC_CH6_CNT			0x00CA
#define IO_DMAC_CH7_ADDR		0x00CC
#define IO_DMAC_CH7_CNT			0x00CE
#define IO_DMAC1_STATUS			0x00D0
#define IO_DMAC1_CMD			0x00D0
#define IO_DMAC1_REQ			0x00D2
#define IO_DMAC1_MASK			0x00D4
#define IO_DMAC1_MODE			0x00D6
#define IO_DMAC1_CLR_FF			0x00D8
#define IO_DMAC1_TMP			0x00DA
#define IO_DMAC1_MASTER_CLR		0x00DA
#define IO_DMAC1_CLR_MASK		0x00DC
#define IO_DMAC1_ALL_MASK		0x00DE

#define DMAC_CH0			0x00
#define DMAC_CH1			0x01
#define DMAC_CH2			0x02
#define DMAC_CH3			0x03
#define DMAC_CH4			0x00
#define DMAC_CH5			0x01
#define DMAC_CH6			0x02
#define DMAC_CH7			0x03

#define DMAC_CH_FDC			0x02

#define DMAC_MODE_DEMAND	0x00
#define DMAC_MODE_SINGLE	0x40
#define DMAC_MODE_BLOCK		0x80
#define DMAC_MODE_CASCADE	0xC0
#define DMAC_MODE_ADDR_INC	0x00
#define DMAC_MODE_ADDR_DEC	0x20
#define DMAC_MODE_VERIFY	0x00
#define DMAC_MODE_READ		0x04
#define DMAC_MODE_WRITE		0x08

#define DMAC_MASK_CLR		0x00
#define DMAC_MASK_SET		0x04

extern bool dmac_init( void );
extern void dmac_enable( u8, u32, u16, u8 );
extern void dmac_disable( u8 );

#endif // !__DMAC_H__
