/*!
******************************************************************************

	@file	cpu.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __CPU_H__
#define __CPU_H__

#ifndef _VSUN86_PCSIM
#include "x86.h"
#endif	//!_VSUN86_PCSIM

typedef struct {
#ifndef _VSUN86_PCSIM
	TSS *			tss;
#else	//_VSUN86_PCSIM
	const void *	code_ptr;
	const void *	stack_ptr;
	u32				flags;
	u32				_r0;
	u32				_r1;
	u32				_r2;
	u32				_r3;
	u32				_r4;
	u32				_r5;
	u32				_r6;
	u32				_r7;
#endif	//_VSUN86_PCSIM
} CPU_CONTEXT;

#define CPU_CONTEXT_MAX		32

extern bool cpu_init( void );
extern void cpu_enable_interrupt( void );
extern void cpu_disable_interrupt( void );
extern bool cpu_get_interrupt_flag( void );
extern void halt( void );

extern CPU_CONTEXT * cpu_alloc_context( const void *, const void *, size_t );
extern void cpu_switch_context( CPU_CONTEXT *, CPU_CONTEXT * );

#endif // !__CPU_H__
