#include "compiler.h"
#include "dosio.h"
#include "scrnmng.h"
#include "soundmng.h"
#include "commng.h"
#include "sysmng.h"
#include "taskmng.h"
#include "kbdmng.h"
#include "pccore.h"
#include "s98.h"
#include "scrndraw.h"
#include "cpucore.h"
#include "diskdrv.h"

static void check_args( const char *args );
static int vm_event_callback( VM_EVENT_CODE, u32, u32 );

EXTERN_C int vm_main( const char *args )
{
	if ( args == NULL )
		return -1;

	strcpy( np2cfg.fontfile, "//0/FONT.ROM" );
	np2cfg.ITF_WORK = TRUE;

	dosio_init();
	file_setcd( "//0/" );

	scrnmng_initialize();
	/*
	soundmng_initialize();
	commng_initialize();
	sysmng_initialize();
	taskmng_initialize();
	*/
	kbdmng_initialize();

	pccore_init();
	S98_init();

	scrndraw_redraw();
	pccore_reset();
	check_args( args );
	pccore_reset();

	Vsun86_SetVMEventCallback( vm_event_callback );

	fprintf( stderr, "cs:eip=%04x:%08x eflags=%08x\n", CPU_CS, CPU_EIP, CPU_EFLAGS );
	fprintf( stderr, "eax=%08x ecx=%08x edx=%08x ebx=%08x\n", CPU_EAX, CPU_ECX, CPU_EDX, CPU_EBX );
	fprintf( stderr, "esp=%08x ebp=%08x esi=%08x edi=%08x\n", CPU_ESP, CPU_EBP, CPU_ESI, CPU_EDI );
	fprintf( stderr, "ss=%04x ds=%04x es=%04x fs=%04x gs=%04x\n", CPU_SS, CPU_DS, CPU_ES, CPU_FS, CPU_GS );

	while ( 1 )
		pccore_exec( TRUE );

	fprintf( stderr, "cs:eip=%04x:%08x eflags=%08x\n", CPU_CS, CPU_EIP, CPU_EFLAGS );
	fprintf( stderr, "eax=%08x ecx=%08x edx=%08x ebx=%08x\n", CPU_EAX, CPU_ECX, CPU_EDX, CPU_EBX );
	fprintf( stderr, "esp=%08x ebp=%08x esi=%08x edi=%08x\n", CPU_ESP, CPU_EBP, CPU_ESI, CPU_EDI );
	fprintf( stderr, "ss=%04x ds=%04x es=%04x fs=%04x gs=%04x\n", CPU_SS, CPU_DS, CPU_ES, CPU_FS, CPU_GS );

	pccore_term();
	S98_trash();

	dosio_term();

	return 0;
}

#define ARGC_MAX	10

static void check_args( const char *args )
{
	char cmdline[256];
	char *argv[ARGC_MAX];
	int argc = 0;

	if ( (args[0] == '\0') )
		return;

	fprintf( stderr, "args=\"%s\"\n", args );

	memcpy( cmdline, args, sizeof(cmdline) );
	cmdline[sizeof(cmdline)-1] = '\0';
	int i=0;
	while ( cmdline[i] != '\0' ) {
		if ( cmdline[i] == ' ' ) {
			cmdline[i] = '\0';
			i++;
		}
		else {
			argv[argc++] = &cmdline[i];
			if ( argc >= ARGC_MAX )
				break;
			while ( (cmdline[i] != ' ') && (cmdline[i] != '\0') )
				i++;
		}
	}

	for ( int i=0; i<argc; i++ ) {
		fprintf( stderr, "argv[%d] = \"%s\"\n", i, argv[i] );
		if ( strncmp( argv[i], "-fd0=", 5 ) == 0 ) {
			diskdrv_setfdd( 0, &argv[i][5], 0 );
//			sysmng_update( SYS_UPDATEOSCFG );
		}
		else if ( strncmp( argv[i], "-fd1=", 5 ) == 0 ) {
			diskdrv_setfdd( 1, &argv[i][5], 0 );
//			sysmng_update( SYS_UPDATEOSCFG );
		}
		else if ( strncmp( argv[i], "-hd0=", 5 ) == 0 ) {
			diskdrv_sethdd( 0, &argv[i][5] );
//			sysmng_update( SYS_UPDATEOSCFG );
		}
		else if ( strncmp( argv[i], "-hd1=", 5 ) == 0 ) {
			diskdrv_sethdd( 1, &argv[i][5] );
//			sysmng_update( SYS_UPDATEOSCFG );
		}
	}
}

static int vm_event_callback( VM_EVENT_CODE code, u32 arg1, u32 arg2 )
{
	switch ( code )
	{
	case VM_EVENT_KEY_DOWN:
//		fprintf( stderr, "VM_EVENT_KEY_DOWN( arg1=%02x, arg2=%02x )\n", arg1, arg2 );
		kbdmng_key_down( (UINT8)arg1, (UINT8)arg2 );
		break;

	case VM_EVENT_KEY_UP:
//		fprintf( stderr, "VM_EVENT_KEY_UP( arg1=%02x, arg2=%02x )\n", arg1, arg2 );
		kbdmng_key_up( (UINT8)arg1, (UINT8)arg2 );
		break;

	default:
		fprintf( stderr, "Unknown Event %08x( arg1=%08x, arg2=%08x )\n", code, arg1, arg2 );
		break;
	}
	return 0;
}
