/*-*- mode: C; Encoding: utf8n -*-*/

#include "compiler.h"
#include "cpucore.h"
#include "pccore.h"
#include "iocore.h"
#include "bios.h"
#include "memtram.h"

#ifndef _VSUN86
#error _VSUN86 not defined.
#endif // _VSUN86

I386CORE i386core;
VCPU	 i386v_softemu_regs;
SVM_VMCB i386v_softemu_vmcb;

static int softemu = 0;

// (i286c.cを参照)
extern void i286c_initialize(void);
extern void i286c_deinitialize(void);
extern void i286c_reset(void);
extern void i286c_shut(void);
extern void i286c_setextsize(UINT32 size);
extern void i286c_setemm(UINT frame, UINT32 addr);
extern void i286c_interrupt(REG8 vect);
extern void i286c(void);
extern void i286c_step(void);

/*
const UINT8 iflags[512] = {					// Z_FLAG, S_FLAG, P_FLAG
			0x44, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x45, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01,
			0x01, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x05,
			0x01, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x05,
			0x05, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01,
			0x01, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x05,
			0x05, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01,
			0x05, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01,
			0x01, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x05,
			0x01, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x05,
			0x05, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01,
			0x05, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01,
			0x01, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x05,
			0x05, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01,
			0x01, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x05,
			0x01, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x05,
			0x05, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01,
			0x81, 0x85, 0x85, 0x81, 0x85, 0x81, 0x81, 0x85,
			0x85, 0x81, 0x81, 0x85, 0x81, 0x85, 0x85, 0x81,
			0x85, 0x81, 0x81, 0x85, 0x81, 0x85, 0x85, 0x81,
			0x81, 0x85, 0x85, 0x81, 0x85, 0x81, 0x81, 0x85,
			0x85, 0x81, 0x81, 0x85, 0x81, 0x85, 0x85, 0x81,
			0x81, 0x85, 0x85, 0x81, 0x85, 0x81, 0x81, 0x85,
			0x81, 0x85, 0x85, 0x81, 0x85, 0x81, 0x81, 0x85,
			0x85, 0x81, 0x81, 0x85, 0x81, 0x85, 0x85, 0x81,
			0x85, 0x81, 0x81, 0x85, 0x81, 0x85, 0x85, 0x81,
			0x81, 0x85, 0x85, 0x81, 0x85, 0x81, 0x81, 0x85,
			0x81, 0x85, 0x85, 0x81, 0x85, 0x81, 0x81, 0x85,
			0x85, 0x81, 0x81, 0x85, 0x81, 0x85, 0x85, 0x81,
			0x81, 0x85, 0x85, 0x81, 0x85, 0x81, 0x81, 0x85,
			0x85, 0x81, 0x81, 0x85, 0x81, 0x85, 0x85, 0x81,
			0x85, 0x81, 0x81, 0x85, 0x81, 0x85, 0x85, 0x81,
			0x81, 0x85, 0x85, 0x81, 0x85, 0x81, 0x81, 0x85};
*/

static void i386v_mmio_write8( u32 addr, u8 data )
{
//	fprintf( stderr, "mmio_write8:  addr=%08x, data=%02x\n", addr, data );
	memtram_wr8( addr, data );
}

static void i386v_mmio_write16( u32 addr, u16 data )
{
//	fprintf( stderr, "mmio_write16: addr=%08x, data=%04x\n", addr, data );
	memtram_wr16( addr, data );
}

static void i386v_mmio_write32( u32 addr, u32 data )
{
	fprintf( stderr, "mmio_write32: addr=%08x, data=%08x\n", addr, data );
}

static VCPU_MMIO_PROCS tram_mmio = {
	NULL,
	NULL,
	NULL,
	i386v_mmio_write8,
	i386v_mmio_write16,
	i386v_mmio_write32
	/*
	memtram_wr8,
	memtram_wr16,
	i386v_mmio_write32
	*/
};

void i386v_initialize( void )
{
	fprintf( stderr, "[STUB] i386v_initialize()\n" );
	ZeroMemory( &i386core, sizeof(i386core) );
	/*
	CPU_REGS = Vsun86_GetVCPU();
	if ( CPU_REGS != NULL )
	{	// VCPUが利用可能
		fprintf( stderr, "cpu: using vcpu core\n" );
		mem = VM_MEM;
		softemu = 0;
		Vsun86_SetVCPU_MMIO( 0xA0, 4, &tram_mmio );
		return;
	}
	*/
	// VCPU利用不可能→ソフトウェアエミュレーションに切り替える
	fprintf( stderr, "cpu: using i286c core\n" );
	ZeroMemory( &i386v_softemu_vmcb, sizeof(&i386v_softemu_vmcb) );
	ZeroMemory( &i386v_softemu_regs, sizeof(&i386v_softemu_regs) );
	i386v_softemu_regs.vmcb = &i386v_softemu_vmcb;
	CPU_REGS = &i386v_softemu_regs;
	mem = malloc( 0x200000 );
	i286c_initialize();
	softemu = 1;
}

void i386v_deinitialize( void )
{
	if ( !softemu ) {
		free( mem );
		fprintf( stderr, "[STUB] i386v_deinitialize()\n" );
	}
	else
		i286c_deinitialize();
}

void i386v_reset( void )
{
	if ( !softemu ) {
		fprintf( stderr, "[STUB] i386v_reset()\n" );
		ZeroMemory( &i386core.s, sizeof(i386core.s) );
	}
	else {
		i286c_reset();
	}
}

void i386v_shut( void )
{
	if ( !softemu ) {
		fprintf( stderr, "[STUB] i386v_shut()\n" );
		ZeroMemory( &i386core.s, sizeof(i386core.s) );
	}
	else {
		i286c_shut();
	}
}

void i386v_setextsize( UINT32 size )
{
	if ( !softemu ) {
		fprintf( stderr, "[STUB] i386v_setextsize( size=%08x )\n", size );
		i386core.e.ems[0] = mem + 0xc0000;
		i386core.e.ems[1] = mem + 0xc4000;
		i386core.e.ems[2] = mem + 0xc8000;
		i386core.e.ems[3] = mem + 0xcc000;
	}
	else {
		i286c_setextsize( size );
	}
}

void i386v_setemm( UINT frame, UINT32 addr )
{
	if ( !softemu ) {
		fprintf( stderr, "[STUB] i386v_setemm( frame=%08x, addr=%08x )\n", frame, addr );
	}
	else {
		i286c_setemm( frame, addr );
	}
}

void CPUCALL i386v_interrupt( REG8 vect )
{
	if ( !softemu ) {
		VSUN86_VCPU_EVENT e;
		fprintf( stderr, "[STUB] i386v_interrupt( vect=%02x )\n", vect );
		e.code = VCPU_EVENT_INTR;
		e.data.vector = vect;
		Vsun86_SetVCPUEvent( &e );
	}
	else {
		i286c_interrupt( vect );
	}
}

void i386v( void )
{
	VSUN86_VCPU_RESULT result;
	static int run = 1;

	if ( softemu ) {
		i286c();
		return;
	}

//	fprintf( stderr, "i386v() ... " );
	if ( run && (0 != Vsun86_RunVCPU( &result )) ) {
//		fprintf( stderr, "intercept ... " );
		run = 0;
		switch ( result.code )
		{
		case VCPU_RESULT_INB:
			if ( !result.data.ioio.str ) {
				CPU_AL = iocore_inp8( result.data.ioio.port );
//				fprintf( stderr, "%04x:%08x INB(%04x) = %02x\n",
//						 CPU_CS, CPU_EIP, result.data.ioio.port, CPU_AL );
				CPU_EIP = result.data.ioio.next_eip;
				run = 1;
			}
			else
				fprintf( stderr, "[STUB] %sINSB\n", result.data.ioio.rep? "REP ":"" );
			break;

		case VCPU_RESULT_INW:
			if ( !result.data.ioio.str ) {
				CPU_AX = iocore_inp16( result.data.ioio.port );
//				fprintf( stderr, "%04x:%08x INW(%04x) = %04x\n",
//						 CPU_CS, CPU_EIP, result.data.ioio.port, CPU_AX );
				CPU_EIP = result.data.ioio.next_eip;
				run = 1;
			}
			else
				fprintf( stderr, "[STUB] %sINSW\n", result.data.ioio.rep? "REP ":"" );
			break;

		case VCPU_RESULT_IND:
			if ( !result.data.ioio.str ) {
				CPU_EAX = iocore_inp32( result.data.ioio.port );
//				fprintf( stderr, "%04x:%08x IND(%04x) = %08x\n",
//						 CPU_CS, CPU_EIP, result.data.ioio.port, CPU_EAX );
				CPU_EIP = result.data.ioio.next_eip;
				run = 1;
			}
			else
				fprintf( stderr, "[STUB] %sINSD\n", result.data.ioio.rep? "REP ":"" );
			break;

		case VCPU_RESULT_OUTB:
			if ( !result.data.ioio.str ) {
//				fprintf( stderr, "%04x:%08x OUTB(%04x, %02x)\n",
//						 CPU_CS, CPU_EIP, result.data.ioio.port, CPU_AL );
				iocore_out8( result.data.ioio.port, CPU_AL );
				CPU_EIP = result.data.ioio.next_eip;
				run = 1;
			}
			else
				fprintf( stderr, "[STUB] %sOUTSB\n", result.data.ioio.rep? "REP ":"" );
			break;

		case VCPU_RESULT_OUTW:
			if ( !result.data.ioio.str ) {
//				fprintf( stderr, "%04x:%08x OUTW(%04x, %04x)\n",
//						 CPU_CS, CPU_EIP, result.data.ioio.port, CPU_AX );
				iocore_out16( result.data.ioio.port, CPU_AX );
				CPU_EIP = result.data.ioio.next_eip;
				run = 1;
			}
			else
				fprintf( stderr, "[STUB] %sOUTSW\n", result.data.ioio.rep? "REP ":"" );
			break;

		case VCPU_RESULT_OUTD:
			if ( !result.data.ioio.str ) {
//				fprintf( stderr, "%04x:%08x OUTD(%04x, %08x)\n",
//						 CPU_CS, CPU_EIP, result.data.ioio.port, CPU_EAX );
				iocore_out32( result.data.ioio.port, CPU_EAX );
				CPU_EIP = result.data.ioio.next_eip;
				run = 1;
			}
			else
				fprintf( stderr, "[STUB] %sOUTSD\n", result.data.ioio.rep? "REP ":"" );
			break;

		case VCPU_RESULT_ICEBP:
			CPU_EIP++;
			biosfunc( CS_BASE + CPU_EIP - 1 );
//			fprintf( stderr, "cs:eip=%04x:%08x\n", CPU_CS, CPU_EIP );
			ES_BASE = CPU_ES << 4;
			CS_BASE = CPU_CS << 4;
			SS_BASE = CPU_SS << 4;
			DS_BASE = CPU_DS << 4;
			run = 1;
			break;

		case VCPU_RESULT_ABORT:
		default:
			break;
		}
	}
//	if ( run == 1 )
//		fprintf( stderr, "OK\n" );
//	else
//		fprintf( stderr, "failed.\n" );
	CPU_REMCLOCK = -1;
}

void i386v_step( void )
{
	if ( !softemu )
		fprintf( stderr, "[STUB] i386v_step()\n" );
	else
		i286c_step();
}

void i386v_a20en( BOOL en )
{
	if ( !softemu )
		fprintf( stderr, "[STUB] i386v_a20en( en=%d )\n", en );
	else
		CPU_ADRSMASK = (en)?0x00ffffff:0x000fffff;
}
