/*!
******************************************************************************

	@file	string.h

	Copyright (C) 2008 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __STRING_H__
#define __STRING_H__

#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

void	memset( void *, int, size_t );
void	memcpy( void *, const void *, size_t );
int		memcmp( const void *, const void *, size_t );

size_t	strlen( const char *s );
char *	strcpy( char *s1, const char *s2 );
char *	strchr( const char *s, int c );
int		strcmp( const char *s1, const char *s2 );
int		strncmp( const char *s1, const char *s2, size_t n );

#ifdef __cplusplus
}
#endif // __cplusplus

#endif //!__STRING_H__
