/*!
******************************************************************************

	@file	string.c

	Copyright (C) 2008 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include <string.h>

void memset( void *dest, int c, size_t count )
{
	size_t i;

	for ( i=0; i<count; i++ )
		((unsigned char *)dest)[i] = (unsigned char)c;
}

void memcpy( void *buf1, const void *buf2, size_t n )
{
	size_t i;

	for ( i=0; i<n; i++ )
		((unsigned char *)buf1)[i] = ((unsigned char *)buf2)[i];
}

int memcmp( const void *buf1, const void *buf2, size_t n )
{
	size_t i;

	for ( i=0; i<n; i++ ) {
		if ( ((unsigned char *)buf1)[i] == ((unsigned char *)buf2)[i] )
			continue;
		else if ( ((unsigned char *)buf1)[i] < ((unsigned char *)buf2)[i] )
			return -1;
		else
			return 1;
	}
	return 0;
}

size_t strlen( const char *s )
{
	size_t i;

	for ( i=0; s[i] != '\0'; i++ )
		;

	return i;
}

char * strcpy( char *s1, const char *s2 )
{
	int i;

	for ( i=0; s2[i] != '\0'; i++ )
		s1[i] = s2[i];
	s1[i] = '\0';

	return s1;
}

char * strchr( const char *s, int c )
{
	int i;

	for ( i=0; s[i] != '\0'; i++ ) {
		if ( s[i] == c )
			return (char *)&s[i];
	}

	if ( s[i] == c )	// c == '\0'
		return (char *)&s[i];

	return NULL;
}

int strcmp( const char *s1, const char *s2 )
{
	unsigned long i;

	for ( i=0; (s1[i] != '\0') && (s2[i] != '\0') ; i++ ) {
		if ( s1[i] != s2[i] )
			return s1[i] - s2[i];
	}

	return s1[i] - s2[i];
}

int strncmp( const char *s1, const char *s2, size_t n )
{
	unsigned long i;

	for ( i=0; i<n; i++ ) {
		if ( s1[i] != s2[i] )
			return s1[i] - s2[i];
	}

	return 0;
}
