/*!
******************************************************************************

	@file	stdarg.h

	Copyright (C) 2008 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __STDARG_H__
#define __STDARG_H__

#include <stddef.h>

typedef __builtin_va_list va_list;

#define va_start( ap, last )	__builtin_va_start( ap, last )
#define va_end( ap )			__builtin_va_end( ap )
#define va_arg( ap, type )		__builtin_va_arg( ap, type )

#ifdef __cplusplus
extern "C" {
#endif

int vprintf  ( const char *fmt, va_list ap );
int vsprintf ( char *str, const char *fmt, va_list ap );
int vsnprintf( char *str, size_t len, const char *fmt, va_list ap );

#ifdef __cplusplus
}
#endif

#endif //!__STDARG_H__
