/*
    avicore
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "icm.h"
#include <gdk/gdkkeysyms.h>
#include "misc/misc.h"
#include "misc/profile.h"


/******************************************************************************
*                                                                             *
* ICM                                                                 *
*                                                                             *
******************************************************************************/
/*	4ʸɢʸ
	handler,4ʸ
	    RET,ʸ															*/
/*static gchar *icm_handler_to_string(const guint handler)
{
	gchar c,*text=NULL,*temp0,*temp1;
	gint i;

	for (i=24;i>=0;i-=8) {
		c=(handler>>i)&0xff;
		temp0=g_strdup_printf(g_ascii_isalnum(c)?"%c":"%%%02x",(guint8)c);
		temp1=g_strconcat(temp0,text,NULL);
		g_free(temp0);
		g_free(text);
		text=temp1;
	}
	return text;
}*/


/*	ʸ4ʸ
	text,ʸ
	 RET,4ʸ														*/
static guint32 icm_string_to_handler(const gchar *text)
{
	gint i,j=0,k;
	guint32 handler=0;

	for (i=0;i<4;i++) {
		handler>>=8;
		if (text[j]=='%') {
			j++;
			for (k=28;k>=24;k-=4) {
				if ('0'<=text[j] && text[j]<='9')
					handler|=(text[j]-'0')<<k;
				else if ('A'<=text[j] && text[j]<='A')
					handler|=(text[j]-'A')<<k;
				else if ('a'<=text[j] && text[j]<='f')
					handler|=(text[j]-'a')<<k;
				else
					break;
				j++;
			}
			if (k>=24)
				return 0;
		} else if (text[j]!='\0') {
			handler|=text[j++]<<24;
		} else {
			return 0;
		}
	}
	return handler;
}


/******************************************************************************
*                                                                             *
* ICM                                                                   *
*                                                                             *
******************************************************************************/
static GHashTable *ghash_handler=NULL,*ghash_path=NULL;


/*	ICM
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean icm_init(void)
{
#ifdef W32CODECDIR
	gchar *file,*key,*value,*path;
	gint i,length;
	guint32 handler;
	GList *glist;
	IcmDriver *icm_driver;
	Profile *profile;

	if (ghash_handler!=NULL || ghash_path!=NULL)
		return FALSE;
	ghash_handler=g_hash_table_new(NULL,g_direct_equal);
	ghash_path=g_hash_table_new(g_str_hash,g_str_equal);
	file=g_strconcat(g_get_home_dir(),"/.",g_basename(g_get_prgname()),NULL);
	if ((profile=profile_open(file))!=NULL) {
		if ((glist=profile_enum_key(profile,"vidc"))!=NULL) {
			length=g_list_length(glist);
			for (i=0;i<length;i++) {
				key=g_list_nth_data(glist,i);
				if ((handler=icm_string_to_handler(key))!=0
					&& g_hash_table_lookup(ghash_handler,
												(gconstpointer)handler)==NULL
					&& (value=profile_get_string(profile,"vidc",key))!=NULL) {
					if (g_path_is_absolute(value)) {
						path=value;
					} else {
						path=g_strconcat(W32CODECDIR,"/",value,NULL);
						g_free(value);
					}
					value=misc_get_full_path(path);
					g_free(path);
					path=value;
					if ((icm_driver=g_hash_table_lookup(ghash_path,
																path))==NULL) {
						/*  */
						if ((icm_driver=g_malloc0(sizeof(IcmDriver)))!=NULL
									&& (icm_driver->pe=peimage_create())!=NULL
									&& peimage_load(icm_driver->pe,path)
									&& (icm_driver->DriverProc=peimage_resolve
										(icm_driver->pe,"DriverProc"))!=NULL) {
							icm_driver->DriverProc(0,icm_driver->pe,
															DRV_LOAD,0,0);
							icm_driver->DriverProc(0,icm_driver->pe,
															DRV_ENABLE,0,0);
							g_hash_table_insert(ghash_path,path,icm_driver);
						} else {
							if (icm_driver->pe!=NULL)
								peimage_destroy(icm_driver->pe);
							g_free(icm_driver);
							g_free(path);
							icm_driver=NULL;
						}
					}
					if (icm_driver!=NULL)	/* Ͽ */
						g_hash_table_insert(ghash_handler,
												(gpointer)handler,icm_driver);
				}
			}
			g_list_free(glist);
		}
		profile_close(profile);
	}
	g_free(file);
#endif
	return TRUE;
}


static void icm_exit_callback(gpointer key,gpointer value,gpointer ghash)
{
	gchar *path;
	IcmDriver *icm_driver;

	if (g_hash_table_lookup_extended((GHashTable*)ghash,key,
									(gpointer)&path,(gpointer)&icm_driver)) {
		g_hash_table_remove((GHashTable*)ghash,key);
		icm_driver->DriverProc(0,icm_driver->pe,DRV_FREE,0,0);
		peimage_destroy(icm_driver->pe);
		g_free(icm_driver);
		g_free(path);
	}
}


/*	ICMλ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean icm_exit(void)
{
	if (ghash_handler!=NULL || ghash_path!=NULL) {
#ifdef W32CODECDIR
		g_hash_table_foreach(ghash_path,icm_exit_callback,ghash_path);
		g_hash_table_destroy(ghash_handler);
		g_hash_table_destroy(ghash_path);
#endif
		ghash_handler=NULL;
		ghash_path=NULL;
	}
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ICM                                                                     *
*                                                                             *
******************************************************************************/
static void icm_get_handler_list_callback(gpointer key,gpointer value,
																GList **glist)
{
	*glist=g_list_append(*glist,key);
}


/*	ϿƤ4ʸɤ
	RET,4ʸɤΥꥹ,NULL:Ͽʤ									*/
GList *icm_get_handler_list(void)
{
	GList *glist=NULL;

	if (ghash_handler!=NULL)
		g_hash_table_foreach(ghash_handler,
								(GHFunc)icm_get_handler_list_callback,&glist);
	return glist;
}


/*	Codec򳫤
	handler,4ʸ
	   mode,⡼
	    RET,IcmObject,NULL:顼											*/
IcmObject *icm_open(const guint32 handler,const gint mode)
{
#ifdef W32CODECDIR
	IcmObject *icm_object;
	ICOPEN icopen;

	icm_object=g_malloc0(sizeof(IcmObject));
	icm_object->counter=1;
	icm_object->handler=handler;
	icm_object->mode=mode;
	if ((icm_object->icm_driver=g_hash_table_lookup(ghash_handler,
											(gconstpointer)handler))!=NULL) {
		g_memset(&icopen,0,sizeof(ICOPEN));
		icopen.dwSize=sizeof(ICOPEN);
		icopen.fccType=ICTYPE_VIDEO;
		icopen.fccHandler=handler;
		switch (mode) {
			case ICM_MODE_COMPRESS:
				icopen.dwFlags=ICMODE_COMPRESS;
				break;
			case ICM_MODE_DECOMPRESS:
				icopen.dwFlags=ICMODE_DECOMPRESS;
				break;
			case ICM_MODE_FASTDECOMPRESS:
				icopen.dwFlags=ICMODE_FASTDECOMPRESS;
				break;
			case ICM_MODE_QUERY:
				icopen.dwFlags=ICMODE_QUERY;
				break;
			case ICM_MODE_FASTCOMPRESS:
				icopen.dwFlags=ICMODE_FASTCOMPRESS;
				break;
			case ICM_MODE_DRAW:
				icopen.dwFlags=ICMODE_DRAW;
		}
		icm_object->dwDriverId=icm_object->icm_driver->DriverProc(1,
						icm_object->icm_driver->pe,DRV_OPEN,0,(LONG)&icopen);
	}
	if (icm_object->dwDriverId==0) {
		g_free(icm_object);
		icm_object=NULL;
	}
	return icm_object;
#else
	return NULL;
#endif
}


/*	CodecĤ
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_close(IcmObject *icm_object)
{
	if (icm_object!=NULL && --(icm_object->counter)<=0) {
#ifdef W32CODECDIR
		icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
									icm_object->icm_driver->pe,DRV_CLOSE,0,0);
#endif
		g_free(icm_object->bmih_in);
		g_free(icm_object->bmih_out);
		g_free(icm_object);
	}
	return TRUE;
}


/*	Codecξ
	icm_object,IcmObject
	  icm_info,
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_get_info(IcmObject *icm_object,IcmInfo *icm_info)
{
#ifdef W32CODECDIR
	gint leng;
	ICINFO icinfo;

	if (icm_object==NULL)
		return FALSE;
	g_memset(&icinfo,0,sizeof(ICINFO));
	icinfo.dwSize=sizeof(ICINFO);
	icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
		icm_object->icm_driver->pe,ICM_GETINFO,(LONG)&icinfo,sizeof(ICINFO));
	leng=misc_widechar_to_multibyte(icinfo.szName,-1,NULL,-1);
	icm_info->name=g_malloc(leng*sizeof(gchar));
	misc_widechar_to_multibyte(icinfo.szName,-1,icm_info->name,leng);
	icm_info->handler=icinfo.fccHandler;
	icm_info->flags=0;
	if ((icinfo.dwFlags&VIDCF_QUALITY)!=0)
		icm_info->flags=ICM_FLAG_QUALITY;
	if ((icinfo.dwFlags&VIDCF_CRUNCH)!=0)
		icm_info->flags|=ICM_FLAG_CRUNCH;
	if ((icinfo.dwFlags&VIDCF_TEMPORAL)!=0)
		icm_info->flags|=ICM_FLAG_TEMPORAL;
	if ((icinfo.dwFlags&VIDCF_COMPRESSFRAMES)!=0)
		icm_info->flags|=ICM_FLAG_COMPRESSFRAMES;
	if ((icinfo.dwFlags&VIDCF_DRAW)!=0)
		icm_info->flags|=ICM_FLAG_DRAW;
	if ((icinfo.dwFlags&VIDCF_FASTTEMPORALC)!=0)
		icm_info->flags|=ICM_FLAG_FASTTEMPORALC;
	if ((icinfo.dwFlags&VIDCF_FASTTEMPORALD)!=0)
		icm_info->flags|=ICM_FLAG_FASTTEMPORALD;
	if ((icinfo.dwFlags&VIDCF_QUALITYTIME)!=0)
		icm_info->flags|=ICM_FLAG_QUALITYTIME;
	icm_info->attribute=ICM_ATTR_WIN32;
	return TRUE;
#else
	return FALSE;
#endif
}


/*	AboutΥݡȤǧ
	icm_object,IcmObject
	       RET,TRUE:ͭ,FALSE:̵											*/
gboolean icm_is_dialog_about(IcmObject *icm_object)
{
#ifdef W32CODECDIR
	return icm_object!=NULL && icm_object->icm_driver->DriverProc
							(icm_object->dwDriverId,icm_object->icm_driver->pe,
													ICM_ABOUT,-1,0)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	Aboutɽ
	icm_object,IcmObject													*/
void icm_dialog_about(IcmObject *icm_object)
{
#ifdef W32CODECDIR
	if (icm_object!=NULL)
		icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
									icm_object->icm_driver->pe,ICM_ABOUT,0,0);
#endif
}


/******************************************************************************
*                                                                             *
* ICM Decompress                                                              *
*                                                                             *
******************************************************************************/
/*	Ÿǽǧ
	icm_object,IcmObject
	      bmih,̤줿ӥåȥޥåפΥإå
	       RET,TRUE:ǽ,FALSE:Բǽ										*/
gboolean icm_decompress_query(IcmObject *icm_object,
												const BitmapInfoHeader *bmih)
{
#ifdef W32CODECDIR
	return icm_object!=NULL && bmih!=NULL
				&& icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
								icm_object->icm_driver->pe,
								ICM_DECOMPRESS_QUERY,(LONG)bmih,0)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	ŸΥեޥåȤΥ
	icm_object,IcmObject
	      bmih,̤줿ӥåȥޥåפΥإå
	       RET,Хȿ,0:顼											*/
gsize icm_decompress_get_format_size(IcmObject *icm_object,
												const BitmapInfoHeader *bmih)
{
#ifdef W32CODECDIR
	if (icm_object==NULL || bmih==NULL)
		return 0;
	return icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
									icm_object->icm_driver->pe,
									ICM_DECOMPRESS_GET_FORMAT,(LONG)bmih,0);
#else
	return 0;
#endif
}


/*	ŸΥեޥåȤ
	icm_object,IcmObject
	   bmih_in,̤줿ӥåȥޥåפΥإå
	  bmih_out,Ÿ줿ӥåȥޥåפΥإå
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress_get_format(IcmObject *icm_object,
					const BitmapInfoHeader *bmih_in,BitmapInfoHeader *bmih_out)
{
#ifdef W32CODECDIR
	return icm_object!=NULL && bmih_in!=NULL && bmih_out!=NULL
		&& icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
			icm_object->icm_driver->pe,
			ICM_DECOMPRESS_GET_FORMAT,(LONG)bmih_in,(LONG)bmih_out)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	Ÿ򳫻Ϥ
	icm_object,IcmObject
	      bmih,̤줿ӥåȥޥåפΥإå
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress_begin(IcmObject *icm_object,
												const BitmapInfoHeader *bmih)
{
#ifdef W32CODECDIR
	if (icm_object==NULL || bmih==NULL
					|| icm_object->bmih_in!=NULL || icm_object->bmih_out!=NULL)
		return FALSE;
	icm_object->bmih_out
					=g_malloc(icm_decompress_get_format_size(icm_object,bmih));
	if (!icm_decompress_get_format(icm_object,bmih,icm_object->bmih_out)
				|| icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
							icm_object->icm_driver->pe,
							ICM_DECOMPRESS_BEGIN,
							(LONG)bmih,(LONG)icm_object->bmih_out)!=ICERR_OK) {
		g_free(icm_object->bmih_out);
		icm_object->bmih_out=NULL;
		return FALSE;
	}
	icm_object->bmih_in=g_memdup(bmih,bm_header_bytes(bmih));
	return TRUE;
#else
	return FALSE;
#endif
}


/*	Ÿλ
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress_end(IcmObject *icm_object)
{
#ifdef W32CODECDIR
	if (icm_object==NULL
				|| (icm_object->bmih_in==NULL && icm_object->bmih_out==NULL))
		return FALSE;
	g_free(icm_object->bmih_in);
	g_free(icm_object->bmih_out);
	icm_object->bmih_in=NULL;
	icm_object->bmih_out=NULL;
	return icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
				icm_object->icm_driver->pe,ICM_DECOMPRESS_END,0,0)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	Ÿ
	icm_object,IcmObject
	     flags,ե饰
	     input,̤줿ǡ
	    output,Ÿ줿ǡ
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress(IcmObject *icm_object,
							const guint flags,gpointer input,gpointer output)
{
#ifdef W32CODECDIR
	ICDECOMPRESS icdecompress;

	if (icm_object==NULL || input==NULL || output==NULL
					|| icm_object->bmih_in==NULL || icm_object->bmih_out==NULL)
		return FALSE;
	icdecompress.dwFlags=0;
	if ((flags&ICM_DECOMPRESS_HURRYUP)!=0)
		icdecompress.dwFlags|=ICDECOMPRESS_HURRYUP;
	if ((flags&ICM_DECOMPRESS_UPDATE)!=0)
		icdecompress.dwFlags|=ICDECOMPRESS_UPDATE;
	if ((flags&ICM_DECOMPRESS_PREROLL)!=0)
		icdecompress.dwFlags|=ICDECOMPRESS_PREROLL;
	if ((flags&ICM_DECOMPRESS_NULLFRAME)!=0)
		icdecompress.dwFlags|=ICDECOMPRESS_NULLFRAME;
	if ((flags&ICM_DECOMPRESS_NOTKEYFRAME)!=0)
		icdecompress.dwFlags|=ICDECOMPRESS_NOTKEYFRAME;
	icdecompress.lpbiInput=icm_object->bmih_in;
	icdecompress.lpInput=input;
	icdecompress.lpbiOutput=icm_object->bmih_out;
	icdecompress.lpOutput=output;
	icdecompress.ckid=0;
	return icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
			icm_object->icm_driver->pe,
			ICM_DECOMPRESS,(LONG)&icdecompress,sizeof(ICDECOMPRESS))==ICERR_OK;
#else
	return FALSE;
#endif
}


/******************************************************************************
*                                                                             *
* ICMؿ                                                         *
*                                                                             *
******************************************************************************/
/* ꥹȥܥå */
static void icm_dialog_select_row(GtkWidget *widget,
				gint row,gint column,GdkEventButton *event,GtkWidget *button)
{
	IcmObject *icm_object;

	gtk_object_set_user_data(GTK_OBJECT(widget),(gpointer)row);
	icm_object=gtk_clist_get_row_data(GTK_CLIST(widget),row);
	gtk_widget_set_sensitive(button,icm_is_dialog_about(icm_object));
}


/* ꥹȥܥå */
static void icm_dialog_unselect_row(GtkWidget *widget,
				gint row,gint column,GdkEventButton *event,GtkWidget *button)
{
	gtk_object_set_user_data(GTK_OBJECT(widget),(gpointer)-1);
	gtk_widget_set_sensitive(button,FALSE);
}


/* ꥹȥܥå˴ */
static void icm_dialog_destroy(GtkWidget *widget,gpointer user_data)
{
	gint i;
	IcmObject *icm_object;

	for (i=0;(icm_object=gtk_clist_get_row_data(GTK_CLIST(widget),i))!=NULL;
																		i++)
		icm_close(icm_object);
}


/* Aboutܥ󤬲줿 */
static void icm_dialog_clicked(GtkWidget *widget,GtkWidget *clist)
{
	icm_dialog_about((IcmObject *)gtk_clist_get_row_data(GTK_CLIST(clist),
						(gint)gtk_object_get_user_data(GTK_OBJECT(clist))));
}


/* ESC줿 */
static gboolean icm_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


/*	Aboutɽ												*/
void icm_about(void)
{
	gchar *text[2];
	gint i,length,row;
	guint key;
	GList *glist;
	GtkAccelGroup *accel;
	GtkWidget *dialog,*clist,*scroll,*hbox,*vbox,*button0,*button1;
	IcmObject *icm_object;
	IcmInfo icm_info;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Video Compression"));
	gtk_window_set_default_size(GTK_WINDOW(dialog),320,240);
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(icm_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	/* ܥ */
	button0=gtk_button_new_with_label(NULL);
	button1=gtk_button_new_with_label(_("OK"));
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button0)->child),_("_About"));
	gtk_widget_add_accelerator(button0,"clicked",accel,key,GDK_MOD1_MASK,0);
	/* ꥹȥܥå */
	clist=gtk_clist_new(2);
	gtk_clist_set_column_title(GTK_CLIST(clist),0,_("Name"));
	gtk_clist_set_column_title(GTK_CLIST(clist),1,_("Attribute"));
	gtk_clist_column_titles_show(GTK_CLIST(clist));
	gtk_clist_column_titles_passive(GTK_CLIST(clist));
	if ((glist=icm_get_handler_list())!=NULL) {
		length=g_list_length(glist);
		for (i=0;i<length;i++)
			if ((icm_object=icm_open((guint32)g_list_nth_data(glist,i),
													ICM_MODE_QUERY))!=NULL) {
				if (icm_get_info(icm_object,&icm_info)) {
					text[0]=icm_info.name;
					switch (icm_info.attribute) {
						case ICM_ATTR_NATIVE:
							text[1]=_("Video maid Native");
							break;
						case ICM_ATTR_WIN32:
							text[1]=_("Win32 Emulation");
							break;
						default:
							text[1]=_("Unknown");
					}
					row=gtk_clist_append(GTK_CLIST(clist),text);
					gtk_clist_set_row_data(GTK_CLIST(clist),row,icm_object);
					g_free(icm_info.name);
				} else {
					icm_close(icm_object);
				}
			}
		g_list_free(glist);
	}
	gtk_clist_set_column_width(GTK_CLIST(clist),0,
						gtk_clist_optimal_column_width(GTK_CLIST(clist),0));
	gtk_clist_set_column_width(GTK_CLIST(clist),1,
						gtk_clist_optimal_column_width(GTK_CLIST(clist),1));
	gtk_signal_connect(GTK_OBJECT(clist),"select-row",
											icm_dialog_select_row,button0);
	gtk_signal_connect(GTK_OBJECT(clist),"unselect-row",
											icm_dialog_unselect_row,button0);
	gtk_signal_connect(GTK_OBJECT(clist),"destroy",icm_dialog_destroy,NULL);
	gtk_object_set_user_data(GTK_OBJECT(clist),(gpointer)-1);
	/* 륦ɥ */
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add(GTK_CONTAINER(scroll),clist);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
									GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	/* ܥ */
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",icm_dialog_clicked,clist);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* ܥå */
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),scroll,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_grab_focus(button1);

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();
}
