#include "mainwindow.h"
#include <QtGui/QApplication>
#include <QLocale>
#include <QTranslator>
#include <QMessageBox>
#include <QDebug>
#include <QTextCodec>
#include "SingleApplication.h"

int main(int argc, char *argv[])
{
	SingleApplication app(argc, argv, "viMind");
	//	NIvV`FbN Ƃ肠x^ɏĂ
	QString buf;
	bool miOpt = false;
	for(int i = 1; i < argc; ++i) {
		if( argv[i][0] == '-' ) {
			if( !strcmp(argv[i] + 1, "mi") )
				miOpt = true;
		}
#if 0
		const unsigned char *ptr = (const unsigned char *)argv[i];
		while( *ptr != '\0' )
			buff += QString("%1 ").arg(*ptr++, 0, 16);
		buff += "\n";
#endif
	}
	QTextCodec *codec = QTextCodec::codecForName("Shift-JIS");		//	for Windows
	if( !miOpt && !app.isFirstApp() ) {   //  2߈ȍ~̃CX^X̏ꍇ
		QString buf;
		for(int i = 1; i < argc; ++i) {
			if( argv[i][0] != '-' ) {
				QString fileName = codec->toUnicode(argv[i]);
				fileName.replace("\xa5", "/");		//	\ = 0xa5
				buf += "\"" + fileName + "\" ";
			}
		}
		buf += "\n";	//	EOL }[N
		app.sendMessage(buf);
		return 0;
	}
#if 0
	if( argc >= 2 ) {
		//const int len = strlen(argv[1]);
		QString buf;
		for(const char *ptr = argv[1]; *ptr != '\0'; ++ptr) {
			buf += QString("%1 ").arg((uchar)*ptr, 0, 16);
		}
		QMessageBox::information(0, "info", buf);
	}
#endif
#if 0
	QString avtext;
	for(int i = 0; i < argc; ++i)
		avtext += QString(argv[i]) + " ";
	QMessageBox::information(0, "info",
					QString("argc = %1 %2").arg(argc).arg(avtext));
#endif
    app.setOrganizationName("N.Tsuda");
    app.setApplicationName("viMind");
	QString locale = QLocale::system().name();
	QTranslator translator;
	bool rc = translator.load(QString("viMind_") + locale);
	if( !rc ) {
		qDebug() << "can't open '" << QString("viMind_") << locale << "'";
	}
	app.installTranslator(&translator);

	MainWindow *w = 0;
	for(int i = 1; i < argc; ++i) {
		if( argv[i][0] != '-' ) {
			QString fileName = codec->toUnicode(argv[i]);
			//fileName.replace("\xa5", "/");		//	\ = 0xa5
			w = new MainWindow(fileName);
			w->show();
		}
	}
	if( !w ) {
		w = new MainWindow();
		w->show();
	}
	QObject::connect(&app, SIGNAL(onRecieved(const QString)), w, SLOT(onRecieved(const QString)));
	return app.exec();
}
