#ifndef PDVIEW_H
#define PDVIEW_H

#include <QWidget>
#include <QPointF>

class Scene;
class Node;

struct PDViewNode
{
	QPointF	m_pos;		//	PDWl |m_pos| < 1.0
	QList<PDViewNode *>	m_children;

public:
	PDViewNode() {};
	~PDViewNode();
};

class PDView : public QWidget
{
	Q_OBJECT

public:
	PDView(Scene *scene, QWidget *parent = 0);
	~PDView();

protected:
	void	setupViewNode();
	QPointF	PDPos(const Node *);
	QPointF	PDtoXY(const QPointF &);
	void	drawNode(QPainter *, const Node *);
	void	drawNode(QPainter *, const Node *, QPointF);
	void	drawBranch(QPainter *, const Node *, QPointF);

protected:
	void	paintEvent ( QPaintEvent * event );

private:
	Scene	*m_scene;
	qreal	m_scale;
	QPointF	m_center;
	PDViewNode	m_vnRoot;
};

#endif // PDVIEW_H
