#ifndef SCENE_H
#define SCENE_H

#include <QGraphicsScene>
#include <QPointer>

class Node;
class QGraphicsEllipseItem;
class QColor;
class QDomElement;
class QImage;
class QAction;
class QMainWindow;

struct GlobalSettings;

class Scene : public QGraphicsScene
{
	Q_OBJECT

public:
	enum Mode {
		COMMAND = 0,	//	R}h[h
		INSERT,			//	m[heLXgҏW[h
	};
	//	}[hڍsJ[\
	enum Cursor {
		HOME = 0,
		END,			//	
		SELALL,			//	SI
	};
	//	VKm[h쐬ʒu
	enum CreatePosition {
		LAST_CHILD = 0,		//	Ō̎qm[hƂč쐬
		JUST_BEFORE,		//	wm[h̒Oɍ쐬
		JUST_AFTER,			//	wm[h̒ɍ쐬
	};

public:
	Scene(QObject *parent);
	Scene(qreal x, qreal y, qreal width, qreal height, const GlobalSettings *, QObject *parent = 0);
	~Scene();

public:
	qreal	rootNodeXPos() const { return m_rootNodeXPos; }
	Mode	mode() const { return m_mode; }
	Node	*rootNode() const { return m_rootNode; }
	Node	*lastNode() const;
	Node	*selectedNode() const { return m_selectedNode; }
	QString	toXmlText(const QRect &wRect) const;
	QSize	size() const { return QSize(sceneRect().width(), sceneRect().height()); }
	QRect	rect() const { return QRect(0, 0, sceneRect().width(), sceneRect().height()); }
	QRectF	defaultSceneRect() const { return m_defaultSceneRect; }
	QRectF	nodeBoundingRect() const { return m_nodeBoundingRect; }
	//QPointF	clickedPos() const { return m_clickedPos; }
	//QPointF	clickedItemPos() const { return m_clickedItemPos; }
	Node	*dragSource() const { return m_dragSource; }
	Node	*dropTarget() const { return m_dropTarget; }
	bool	toDropAsChild() const { return m_toDropAsChild; }
	bool	droppedToSameScene() const { return m_droppedToSameScene; }
	QPointF	mousePos() const { return m_mousePos; }

	const GlobalSettings	*globalSettings() const { return m_globalSettings; }

public:
	void	setGlobalSettings(const GlobalSettings *ptr) { m_globalSettings = ptr; }
	void	setClean();
	void	setRootNodeXPos(qreal);
	void	setMode(Mode m, Cursor = HOME);
	void	setSelectedNode(Node *, bool toClear = true);
	void	setRootNode(Node *root) { m_rootNode = root; }
	void	setMousePressedNode(Node *node) { m_mousePressedNode = node; }
	void	setDefaultSceneRect(const QRectF r) { m_defaultSceneRect = r; }
	void	setRootNodeDefaultFont();
	//void	setClickedPos(const QPointF &pnt) { m_clickedPos = pnt; }
	//void	setClickedItemPos(const QPointF &pnt) { m_clickedItemPos = pnt; }
	void	removeAll();
	void	layoutAll();
	Node	*createChildNode(Node *, const QString title = QString());
	Node	*createNode(Node *, CreatePosition, const QString title = QString(), bool = false);
    Node	*createNode(Node *, CreatePosition, const QDomElement &, bool, bool = false);
    void	setFillColor(const QColor &color);
    void	setFont(const QFont &font);
    Node	*addNode(Node *, const QDomElement &, bool);
    Node	*addNode(Node *, CreatePosition, const QDomElement &, bool);
    void	addToFloatingNodes(Node *node);
    void	removeFromFloatingNodes(Node *node);
    void	setDefaultFont(Node *);
    void	removeNode(Node *);
    //void	insertNode(Node *, Node *, int);
    bool	findNext(const QString &);
    bool	findPrev(const QString &);
	void	doMoveNodeUp();				//	m[hړ
	void	doMoveNodeDown();			//	m[hړ
	//void	doMoveNodeLeft();			//	m[hړ
	//void	doMoveNodeRight();			//	m[hEړ
	void	doCollapseExpand(Node *);		//	m[hWJE܏
	void	emitOpenLink(const QString &path) { openLink(path); }
	void	getCurFileName(QString &);
	void	doShowMessage(const QString &, int = 0);
	void	updateBackground();
	void	setDragSource(Node *node) { m_dragSource = node; }
	void	setDropTarget(Node *node) { m_dropTarget = node; }
	void	setTopDropAsChild(bool b) { m_toDropAsChild = b; }
	void	setDroppedToSameScene(bool b) { m_droppedToSameScene = b; }

public slots:
	void	doCurUp();
	void	doCurDown();
	void	doCurLeft();
	void	doCurRight();
	void	doCurFirstSibling();	//	ZI
	void	doCurLastSibling();		//	I
	void	doCurRoot();			//	[gm[hI
	void	doCurLast();			//	Ō̃m[hI
	void	doCurNextTree();
	void	doCurPrevTree();
	void	addParentNode();
	Node	*addChildNode(const QString = QString());
	void	openNextNode(const QString = QString());
	Node	*openPrevNode();
	void	addFloatingNode();
	void	insertPicture();
	void	insertLink();
	void	insertFileLink();
	void	editNode();
	void	editNodeAndSelect();
	void	undo();
	void	redo();
	void	deleteSelectedItemsWithoutChildren();
	void	deleteSelectedItems();
	void	yankSelectedItems();
	void	doDelete(Node *);
    void	cut();
    void	copy();
    void	paste();
    void	pasteChildCB();
    void	selectAll();
	void	moveNodeUp();				//	m[hړ
	void	moveNodeDown();			//	m[hړ
	void	moveNodeLeft();			//	m[hړ
	void	moveNodeRight();			//	m[hEړ
	//void	doMoveNodeLeft();			//	m[hړ
	//void	doMoveNodeRight();			//	m[hEړ
	void	doCollapseExpand();		//	m[hWJE܏
	void	doCollapse1();			//	qm[h܏
	void	doCollapse2();			//	m[h܏
	void	doCollapse3();			//	Бm[h܏
	void	onSelectionChanged();
	void	onContentsChanged();
	void	selectedNodeClicked(Node *);
	void	editInputDate();
	void	editInputImage();
	void	expandAll();
	void	collapseAll();
	void	formatALignLeft();
	void	formatALignCenter();
	void	formatALignRight();
	void	formatALignColumn();
    //void	naviRootNode();		//	[gm[hړ
    //void	naviLastNode();		//	Ō̃m[hړ
    void	formatFork();
    void	formatRect();
    void	formatRoundRect();
    void	formatCircleRect();
    void	nodeDownward(bool);
    void	viewLink();
    void	doCurForwardNode();
    void	doCurBackwardNode();
    void	dragMove(Node *src, Node *dst, bool, bool);
    void	rootNodeMoved(Node *, const QPointF &);

protected:
	void	init();
	void	createActions();
	//void	mouseDoubleClickEvent ( QGraphicsSceneMouseEvent * mouseEvent );
	//void	setElement(QDomElement &ptr);
	//void	doMoveUp(Node *);				//	m[hړ
	//void	doMoveDown(Node *);				//	m[hړ
	Node	*doPaste(const QString &, Node *, CreatePosition, bool = true, bool = false, const QPointF = QPointF(0,0));
	void	pasteFromCB(CreatePosition);
	void	pasteFromYankBuffer(CreatePosition);
	void	pasteChild();
	void	pasteNext();
	void	pastePrev();
	void	setTextALign(Qt::Alignment);
	void	moveNodeLeft(Node *);			//	m[hړ
	void	moveNodeRight(Node *);			//	m[hEړ
	void	setNodeStyle(uchar);
	void	doCollapse(int);				//	w背x̃m[h܏
	Node	*findNewerNode(const Node *);	//	XVtԂɐVm[hT
	Node	*findOlderNode(const Node *);	//	XVtԂɌÂm[hT
	void	flipSelection();
    void	doDrop(const QString &, Node *dst, bool, bool, const QPointF &);

protected:
	void	keyPressEvent ( QKeyEvent * keyEvent );
	void	contextMenuEvent ( QGraphicsSceneContextMenuEvent *event );
#if 1
	void	dragEnterEvent ( QGraphicsSceneDragDropEvent * event );
	void	dragMoveEvent ( QGraphicsSceneDragDropEvent * event );
	void	dropEvent ( QGraphicsSceneDragDropEvent * event );
#endif

signals:
	void	modeChanged();
	void	contentsChanged();
	void	canUndoChanged(bool);
	void	canRedoChanged(bool);
	void	toFind();			//	/
	void	toFindNext();		//	n
	void	toFindPrev();		//	N
	void	showMessage(const QString &, int = 0);
	void	toUpdateView();
	void	cleanChanged ( bool clean );
	void	curNodeChanged(Node *);
	void	nodeCreated(Node *);
	void	openLink(const QString &);
	void	curFileName(QString &);

private:
	const GlobalSettings	*m_globalSettings;
	qreal	m_rootNodeXPos;			//	[gm[hXW
	Mode	m_mode;
	QRectF	m_defaultSceneRect;		//	ftHg̃V[`
	QRectF	m_nodeBoundingRectRaw;	//	Sm[h`
	QRectF	m_nodeBoundingRect;		//	Sm[h{}[W`
	int		m_orgLevel;			//	㉺ړA{̃x̍
	Node	*m_rootNode;		//	[gm[h
	Node	*m_selectedNode;	//	Im[h
	Node	*m_prevSelectedNode;	//	ȑO̔Im[h
	Node	*m_mousePressedNode;	//	}EXꂽm[h
	//Node	*m_yankedNode;		//	bNobt@m[h
	//QGraphicsEllipseItem	*m_rootBackGroundItem;
	QString	m_yankBuffer;		//	d ō폜ꂽm[heLXg
	QPointer<Node>	m_leftSideReturnNode;		//	[gm[h獶ɖ߂ꍇ̎qm[h
	QList<QPointer<Node> >	m_floatingNodes;	//	t[eBOm[h
	class UndoMgr	*m_undoMgr;
	QList<QImage *>	m_imageList;
	//QPointF	m_clickedPos;		//	}EXNbNꂽʒu
	//QPointF	m_clickedItemPos;	//	}EXNbÑACeʒu

	Node	*m_dragSource;
	Node	*m_dropTarget;
	bool	m_toDropAsChild;			//	qm[hƂăhbv
	bool	m_droppedToSameScene;		//	V[Ƀhbvꂽ
	QPointF	m_mousePos;
	Node	*m_editNode;	//	ҏWm[h
	QString	m_orgText;		//	ҏWOeLXg

//private:
//	QAction	*m_deleteAct;		//	m[h폜
};

#endif // SCENE_H
