#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include "GlobalSettings.h"

class QAction;
class QActionGroup;
class QToolButton;
class Node;
class QDomElement;
class QLabel;
class QIcon;
class QColor;
class QComboBox;
class QToolBar;
class QFontComboBox;
class QLineEdit;
class QTreeWidget;
class QModelIndex;
//class GlobalSettings;

class MainWindow : public QMainWindow
{
	Q_OBJECT

	enum {
		MaxRecentFindStings = 16,
	};
public:
	MainWindow(QWidget *parent = 0, Qt::WFlags flags = 0);
	MainWindow(const QString &fileName, QWidget *parent = 0, Qt::WFlags flags = 0);
	~MainWindow();

public:
	const GlobalSettings	*globalSettings() const { return &m_globSettings; }

protected:
	void	init();
	void	createActions();
    void	createMenus();
    void	createToolBars();
    void	createDockWindows();
    void	setupStatusBar();
    void	readSettings();
    void	writeSettings();
    QMenu	*createColorMenu(const char *slot, QColor defaultColor);
    QIcon	 createColorIcon(QColor color);
    QIcon	createColorToolButtonIcon(const QString &image, QColor color);
    void	fillColorChanged(QAction*);

    void	updateWindowTitle();
    void	updateCurFile();
    bool	maybeSave();
    bool	saveFile(const QString &fileName);
    bool	loadFileToThisMainWindow(const QString &fileName);
    void	loadFile(const QString &fileName);
    void	setCurrentFile(const QString &fileName);
	bool	setContent(const QByteArray &);
    void	updateRecentFileActions();
    void	updateRecentFileActionsOfAllMainWindows();
    void	updateFavoriteFileActions();
    void	updateFavoriteFileActionsOfAllMainWindows();
    QString	strippedName(const QString &fullFileName);
    MainWindow	*findMainWindow(const QString &fileName);
	void	addNode(Node *, QDomElement &);
    Node	*newChild(Node *, const QString &title = QString());
    void	find(bool forward);
    bool	isIMEOpen();		//	IME ON ?
    void	addToWindowsList(const QString &);
    void	removeFromWindowsList(const QString &);
    void	layoutAllWindows();
    QString	curDir() const;			//	}bvtpXĂƂ́ÃfBNgԂ
    void	addToFavoriteFiles(const QString &);
protected:
	void	dragEnterEvent ( QDragEnterEvent * event );
	void	dropEvent ( QDropEvent * event );
	void	closeEvent(QCloseEvent *event);
	bool	eventFilter(QObject *obj, QEvent *event);

protected slots:
	void	exit();
	void	newFile();
	void	open();
    bool	save();
    bool	saveAs();
    void	saveAll();
    void	saveAllExit();
    void	openRecentFile();
    void	openFavoriteFile();
    //void	openFavoriteFile();
    void	openRecentWindow();
    void	addToFavoriteFiles();
    void	print();
    void	printPreview();
    void	onPaintRequested(QPrinter*);
    //void	editInputDate();
    void	modeChanged();
    void	documentWasModified();
    void	fillColorChanged();
    void	fillButtonTriggered();
    void	fillColorSelect();
    void	namedColorSelect();
    void	currentFontChanged(const QFont &font);
    void	fontSizeChanged(const QString &size);
    void	handleFontChange();
    void	findNext();
    void	findPrev();
    void	toFind();		//	R{{bNXɃtH[JXړ
    void	sceneProp();
	void	saveAndTurnOffIME();		//	IME ON/OFF ۑ
	void	restoreIMEOPenStatus();		//	IME ON/OFF ԕA
	void	turnOffIME();
	void	turnOnIME();
    void	cleanChanged(bool);
    void	curNodeChanged(Node *);
	void	nodeCreated(Node *);
	void	nodeListItemActivated(const QModelIndex &);
	void	nodeListHeaderPressed(int);
	void	showMessage(const QString &, int = 0);
	void	settings();
	void	howToUse();
	void	revRef();
	void	viMindWebSite();
	void	about();
	void	fullScreen(bool);
	void	viewPD(bool);
	void    onRecieved(const QString);
    void	updateRecentWindowsActions();
    void	openLink(const QString &);
    void	curFileName(QString &);		//	t@C擾

private:
    QString	m_curFile;		//	t@Ĉ݁i܊gqj
    QString	m_curFullPath;
    bool	m_isUntitled;
    bool	m_isModified;
    bool	m_isIMEOpenForMenu;		//	IME I[vԂH
    bool	m_isIMEOpen;			//	IME I[vԂH
    bool	m_notUpdateNodeFont;	//	m[h̃tHgύXsȂ
	class Scene		*m_scene;
	class View		*m_view;
	class PDView	*m_PDView;
	QLabel	*m_modePane;
	QTreeWidget	*m_nodeList;		//	m[hꗗ

private:
    QAction *m_newAct;
    QAction *m_openAct;
    QAction *m_saveAct;
    QAction *m_saveAsAct;
    QAction *m_saveAllAct;
    QAction *m_saveAllExitAct;
    QAction *m_closeAct;
    QAction *m_exitAct;				//	S}bvāAI
    QAction *m_addFavMapAct;
    ///QAction *m_separatorMRUAct;
    QAction *m_scenePropAct;
    QAction *m_printAct;
    QAction *m_printPreviewAct;

    QAction *m_newChildNodeAct;
    QAction *m_newSiblingNodeAct;

    QAction	*m_undoAct;
    QAction	*m_redoAct;
    QAction	*m_deleteAct;
    QAction	*m_cutAct;
    QAction	*m_copyAct;
    QAction	*m_pasteAfterAct;
    QAction	*m_pasteChildAct;
    QAction	*m_selectAllAct;

    QAction	*m_editNodeAct;
    QAction	*m_editNodeAndSelectAct;
    QAction	*m_editInsertDateAct;
    QAction	*m_editInsertImageAct;

    QAction	*m_moveNodeLeftAct;
    QAction	*m_moveNodeRightAct;
    QAction	*m_moveNodeUpAct;
    QAction	*m_moveNodeDownAct;

    QAction	*m_findAct;
    QAction	*m_findNextAct;
    QAction	*m_findPrevAct;

    QAction	*m_insertParentNodeAct;
    QAction	*m_insertChildNodeAct;
    QAction	*m_insertPrevNodeAct;
    QAction	*m_insertNextNodeAct;
    QAction	*m_insertFloatingNodeAct;

    QAction	*m_insertPictureAct;
    QAction	*m_insertFileLinkAct;
    QAction	*m_insertLinkAct;

    QAction	*m_collapseAllAct;
    QAction	*m_expandAllAct;
    QAction	*m_collapseExpandAct;		//	qm[hWJE܏
    QAction	*m_collapse1Act;			//	qm[h܏
    QAction	*m_collapse2Act;			//	m[h܏
    QAction	*m_collapse3Act;			//	Бm[h܏

    QAction	*m_viewRotateResetAct;		//	]\Zbg
    QAction	*m_viewScaleResetAct;		//	\{100%
    QAction	*m_viewZoomInAct;
    QAction	*m_viewZoomOutAct;
    QAction	*m_viewAutoZoomAct;			//	}bvŜ\悤gk
    QAction	*m_viewFullScreenAct;
    QAction	*m_viewPDAct;

    QActionGroup	*m_nodeStyleGroup;
    QAction	*m_formatForkAct;
    QAction	*m_formatRectAct;
    QAction	*m_formatRoundRectAct;
    QAction	*m_formatCircleRectAct;
    QAction	*m_formatAlignColumnAct;	//	qm[h̃J𑵂
    QActionGroup	*m_alignGroup;
    QAction	*m_formatAlignLeftAct;
    QAction	*m_formatAlignCenterAct;
    QAction	*m_formatAlignRightAct;
    QAction	*m_nodeDownwardAct;			//	qm[hɔzu

    QAction	*m_naviRootAct;				//	[gm[hړ
    QAction	*m_naviLastAct;				//	ԍŌ̃m[hړ
    QAction	*m_naviNextTreeAct;			//	̃c[Ɉړ
    QAction	*m_naviPrevTreeAct;			//	Õc[Ɉړ
    QAction	*m_naviForwardNodeAct;
    QAction	*m_naviBackwardNodeAct;

    QAction	*m_settingsAct;
    QAction	*m_howToUseAct;
    QAction	*m_revRefAct;
    QAction	*m_viMindSiteAct;
    QAction	*m_aboutAct;

    QComboBox *m_fontSizeCombo;
    QFontComboBox *m_fontCombo;
    QAction *m_fillColorAct;
    QToolButton *m_fillColorToolButton;		//	hԂF{^
    //QLineEdit	*m_findLineEdit;
    QComboBox	*m_findCombo;
    QToolBar	*m_findToolBar;

    enum { MaxRecentFiles = 10+26 };
    QAction *m_recentFileActs[MaxRecentFiles];

    enum { MaxFavoriteFiles = 10+26 };
    QAction *m_favoriteFileActs[MaxFavoriteFiles];

    enum { MaxRecentWindows = 10 };
    QAction *m_recentWindowActs[MaxRecentWindows];
    QMenu	*m_windowMenu;

    GlobalSettings	m_globSettings;

    //static QStringList	m_windowsList;		//	I[vĂEBhẼtpX
};

#endif // MAINWINDOW_H
