/**
 * \file uzume.h
 *
 *  \date 2011/11/04
 *  \author takemasa
 *  \details
 *  Uzumeフレームワークのコンフィギュレーション・パラメータ
 */


#ifndef UZUME_H_
#define UZUME_H_

/**
 * \defgroup uzume Uzume API
 * \details
 * オーディオ・フレームワーク、UzumeのAPI群。Uzumeの
 * APIは、特に断らない限り、uITRONのタスク・コンテキストから呼び出すことを前提としている。
 */

/**
 * \defgroup uzume_callback Uzume Callback
 * \details
 * Uzumeが呼び出すコールバック関数。 audio_processing.c で定義され、ユーザーが内部
 * アルゴリズムを記述する。コールバックのタイミングはUzumeが決め、ユーザーが制御することは
 * できない。そのため、アルコールバックがどのタスクに属しているかは重要な問題である。
 */
/**
 * \addtogroup uzume
 * @{
 * */
	/**
	 * \brief UZUMEフレームワークが提供するADCの数。
	 */
#define UZUME_NUM_ADC		4
	/**
	 * \brief UZUMEフレームワークが提供するDACの数。
	 */
#define UZUME_NUM_DAC		0
	/**
	 * \brief UZUMEフレームワークが提供するボタンスイッチの数。
	 */
#define UZUME_NUM_BUTTON		4
	/**
	 * \brief UZUMEフレームワークが提供するステータスLEDの数。
	 */
#define UZUME_NUM_LED		4

	/**
	 * \brief DMAブロック転送のサイズ
	 * \details
	 * 一回のDMA転送でI2Sペリフェラルとの間でコピーされるデータのサンプル数。KirishimaのI2S CODECはステレオなので、
	 * 左右合わせてこのサイズの２倍が転送される。一回のDMA転送ごとに割り込みが入るので、結局UZUME_BLOCK_SIZEサンプル
	 * 毎に割り込みが入る。
	 */
#define UZUME_BLOCK_SIZE		48

	/**
	 * \brief ADCが返す値の型。
	 * \details
	 * Kirishimaボードでは、ADCの型を16bit符号付き整数として扱う。これは、LPC1768の
	 * 内蔵ADCの精度が12bitであること、および、AUDIO_SAMPLEが16bitであるためである。
	 */
typedef signed short ADC_SAMPLE	;

	/**
	 * \brief オーディオ・データの型。
	 * \details
	 * Kirishimaボードでは、オーディオ・データを16bit符号付き整数として扱う。
	 * これは、使用するMMCODEC01の精度を考えれば、小さすぎる型である。I2Sから
	 * 入力するデータに合わせるなら、32bit符号付きせいすうのほうがよい。しかしながら、
	 * CORTEX-M3にとって自然な信号処理サイズは16bitであり、大幅な性能ダウンを
	 * 受け入れないのならば、16bit整数が妥当である。。
	 */
typedef signed short AUDIO_SAMPLE;
/**
 * @}
 *  */

#include "adc_subsystem.h"
#include "audio_subsystem.h"
#include "codec_subsystem.h"
#include "i2s_subsystem.h"
#include "led_subsystem.h"

#endif /* UZUME_H_ */
