/**
 * @file bsp_bluetank.c
 * @author takemasa
 * @brief ACB-BF592, SGTL-5000ブレッドボード用のリソース
 * @details
 * ここにはBSP専用のリソースを置く。実際にはボードの初期化子を置く。
 */
#include <s_services.h>
#include <t_services.h>
#include <cdefBF592-A.h>
#include <bsp_bb_bf592_sgtl5000_nts.h>
#include <rotenc.h>

void board_initialize(VP_INT exinf)
{
    // ADSP-BF592 PORTG設定
    // DR0PRI, RSCK0, RFS0, TD0PRI, TSCK0, TSF0をMUXで0 ( Primary func )にする
    *pPORTG_MUX &= ~0x00ee;

    // ADSP-BF592 PORTG設定
    // DR0PRI, RSCK0, RFS0, TD0PRI, TSCK0, TSF0をFERでイネーブルにする
    *pPORTG_FER = 0x00ee;
}

/**
 * \brief ボリューム値の取得
 * \param ch 0から始まるチャンネル指定番号。
 * ^return 取得したチャンネルの値
 * \details
 */

fract32 get_volume(unsigned int ch)
{
    if ( ch >= UZUME_NUM_VOLUME)
        return 0;

    return 0x7FFFFFFF;
}

/**
 * \brief ボリューム値の設定
 * \param ch 0から始まるチャンネル指定番号。AD7999は3まで
 * \param value 32bit符号付き固定小数点数のボリューム設定値
 * \details
 * ボリュームに初期値を与える。
 */

void set_volume(unsigned int ch, fract32 value)
{
}
