package org.unitedfront2.web.mail;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class TestUser implements Serializable {

    private static final long serialVersionUID = -1768281400450511866L;

    private String name;

    private String to;

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof TestUser)) {
            return false;
        }
        TestUser castOther = (TestUser) other;
        return new EqualsBuilder().append(name, castOther.name).append(to,
                castOther.to).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).append(to).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("name", name).append("to", to).toString();
    }

    public String getName() {
        return name;
    }

    public String getTo() {
        return to;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTo(String to) {
        this.to = to;
    }

}
