package org.unitedfront2.domain.accesscontrol;

import org.junit.Test;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.Profile;

public class UserOnlyTest extends AccessControlTestSupport {

    @Override
    protected AccessControl getAccessControl() {
        return domainFactory.prototype(UserOnly.class);
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToResourceɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.find(simpleUser1.getId());
        accessControl.access(profile);
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToCopyrightedResourceɂANZX() throws AccessDeniedException {
        Message message = profileTable.find(simpleUser1.getId()).getSelfIntroduction();
        accessControl.access(message);
    }

    @Test
    public void testAccessToResource[UɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.find(simpleUser1.getId());
        accessControl.access(profile, simpleUser1.getId());
    }

    @Test
    public void testAccessToCopyrightedResource[UɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.find(simpleUser1.getId());
        accessControl.access(profile.getSelfIntroduction(), simpleUser1.getId());
    }
}
