package org.unitedfront2.domain.accesscontrol;

import org.junit.Test;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.Profile;

public class OwnerOnlyTest extends AccessControlTestSupport {

    @Override
    protected AccessControl getAccessControl() {
        return domainFactory.prototype(OwnerOnly.class);
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToResourceɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.find(simpleUser1.getId());
        accessControl.access(profile);
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToCopyrightedResourceɂANZX() throws AccessDeniedException {
        Message message = profileTable.find(simpleUser1.getId()).getSelfIntroduction();
        accessControl.access(message);
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToResourceL҈ȊOɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.find(simpleUser1.getId());
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setCode("_____tester");
        simpleUser.setId(-1);
        simpleUser.setName("_____eX^[");
        User user = domainFactory.prototype(simpleUser, User.class);
        accessControl.access(profile, user.getId());
    }

    @Test(expected=AccessDeniedException.class)
    public void testAccessToCopyrightedResourceL҈ȊOɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.find(simpleUser1.getId());
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setCode("_____tester");
        simpleUser.setId(-1);
        simpleUser.setName("_____eX^[");
        User user = domainFactory.prototype(simpleUser, User.class);
        accessControl.access(profile.getSelfIntroduction(), user.getId());
    }
}
