package org.unitedfront2.domain.accesscontrol;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public abstract class AccessControlTestSupport extends
        TransactionalTestCaseWithInitialData {

    protected AccessControl accessControl;

    @Autowired protected AccessControlTable accessControlTable;

    @Autowired protected ProfileTable profileTable;

    @Override
    public void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        accessControl = getAccessControl();
        profileTable.install(simpleUser1.getId());
        profileTable.install(simpleUser2.getId());
        profileTable.install(simpleUser3.getId());
    }

    @Test
    public void testEquals() {
        accessControl = (AccessControl) domainFactory.prototype((Class<? extends Domain>) accessControl.getType());
        AccessControl accessControl2 = (AccessControl) domainFactory.prototype((Class<? extends Domain>) accessControl.getType());
        Assert.assertEquals(accessControl, accessControl2);
    }

    @Test
    public void testAccessToResourceL҂ɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.find(simpleUser1.getId());
        accessControl.access(profile, simpleUser1.getId());
        Assert.assertTrue(true);
    }

    @Test
    public void testAccessToCopyrightedResourceL҂ɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.find(simpleUser1.getId());
        accessControl.access(profile.getSelfIntroduction(), simpleUser1.getId());
        Assert.assertTrue(true);
    }

    @Test
    public void testAccessToResourceŏIXVقȂ鏊L҂ɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.find(simpleUser1.getId());
        simpleUser1.setLastAccessDate(null);
        accessControl.access(profile, simpleUser1.getId());
        Assert.assertTrue(true);
    }

    @Test
    public void testAccessToCopyrightedResourceŏIXVقȂ鏊L҂ɂANZX() throws AccessDeniedException {
        Profile profile = profileTable.find(simpleUser1.getId());
        simpleUser1.setLastAccessDate(null);
        accessControl.access(profile.getSelfIntroduction(), simpleUser1.getId());
        Assert.assertTrue(true);
    }

    @Test
    public void testStoreo^() {
        accessControl.store();
        Assert.assertNotNull(accessControl.getId());
        AccessControl foundAccessControl = accessControlTable.find(accessControl.getId());
        Assert.assertEquals(accessControl, foundAccessControl);
    }

    @Test
    public void testStoreXV() {
        accessControl.store();
        accessControl.changeTo(getChangeTo());
        accessControl.store();
        AccessControl foundAccessControl = accessControlTable.find(accessControl.getId());
        Assert.assertEquals(accessControl, foundAccessControl);
    }

    /** eXgΏۂ̃ANZX */
    protected abstract AccessControl getAccessControl();

    /**
     * ύX̃ANZX̌^擾܂B̎ {@link Public}@ԂĂ܂AKv
     * ăI[o[ChĂB
     *
     * @return ANZX̌^
     */
    protected Class<? extends AccessControl> getChangeTo() {
        return Public.class;
    }
}
