package org.unitedfront2.domain;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Assert;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class WidgetsTest extends TransactionalTestCaseWithInitialData {

    @Autowired private SimpleUserTable simpleUserTable;

    @Autowired private WidgetTable widgetTable;

    @Test
    public void testInstall() {
        Assert.assertNotNull(simpleUserTable.find(simpleUser1.getId()));
        widgetTable.install(simpleUser1.getId());
        Assert.assertTrue(widgetTable.find(simpleUser1.getId()).contains(Widget.GOOGLE_SEARCH));
    }

    @Test
    public void testFind() {
        List<Widget> list = new ArrayList<Widget>(2);
        list.add(Widget.PUBLIC_COMMUNITIES);
        list.add(Widget.FOOTMARK);
        widgetTable.store(simpleUser1.getId(), list);

        List<Widget> found = widgetTable.find(simpleUser1.getId());
        Assert.assertEquals(list, found);
    }

    @Test
    public void testStore() {
        List<Widget> list = new ArrayList<Widget>(2);
        list.add(Widget.PUBLIC_COMMUNITIES);
        list.add(Widget.FOOTMARK);

        Assert.assertNotNull(simpleUserTable.find(simpleUser1.getId()));
        widgetTable.store(simpleUser1.getId(), list);
        List<Widget> found = widgetTable.find(simpleUser1.getId());
        Assert.assertEquals(list, found);
    }
}
