package org.unitedfront2.domain;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SubSampleDomain extends SampleDomain {

    /** VAԍ */
    private static final long serialVersionUID = 4173914850918414475L;

    private String title;

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("id", getId())
            .append("d", getD())
            .append("text", getText())
            .append("bool", getBool())
            .append("date", getDate())
            .append("state", getState())
            .append("title", title).toString();
    }

    @Override
    public boolean equals(final Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof SubSampleDomain)) {
            return false;
        }
        SubSampleDomain castOther = (SubSampleDomain) other;
        return new EqualsBuilder()
            .append(getId(), castOther.getId())
            .append(getD(), castOther.getD())
            .append(getText(), castOther.getText())
            .append(getBool(), castOther.getBool())
            .append(getDate(), castOther.getDate())
            .append(getState(), castOther.getState())
            .append(title, castOther.title).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(getId())
            .append(getD())
            .append(getText())
            .append(getBool())
            .append(getDate())
            .append(getState())
            .append(title).toHashCode();
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}
