package org.unitedfront2.domain;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.validation.Validate;
import org.unitedfront2.validation.ValidationException;

/**
 * {@link SampleDomain} ̌؃NXłB
 *
 * @author kurokkie
 *
 */
public class SampleDomainValidator implements Serializable {

    /** ftHg̃R[h̍ŏ̃ftHg (2) */
    public static final int DEFAULT_CODE_MIN_LENGTH = 2;

    /** ftHg̃R[h̍ő啶̃ftHg (32) */
    public static final int DEFAULT_CODE_MAX_LENGTH = 32;

    /** ftHg̃R[h̐K\ ([\p{Alnum}]*) */
    public static final String DEFAULT_CODE_REGEX = "[\\p{Alnum}]*";

    /** ftHg̃eLXg̍ő啶 (128) */
    public static final int DEFAULT_TEXT_MAX_LENGTH = 128;

    /** VAԍ */
    private static final long serialVersionUID = 8383063072303370633L;

    /** R[h̍ŏ */
    private int codeMinLength = DEFAULT_CODE_MIN_LENGTH;

    /** R[h̍ő啶 */
    private int codeMaxLength = DEFAULT_CODE_MAX_LENGTH;

    /** R[h̐K\ */
    private String codeRegex = DEFAULT_CODE_REGEX;

    /** eLXg̍ő啶 */
    private int textMaxLength = DEFAULT_TEXT_MAX_LENGTH;

    /** TvhCe[u */
    private transient SampleDomainTable sampleDomainTable;

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof SampleDomainValidator)) {
            return false;
        }
        SampleDomainValidator castOther = (SampleDomainValidator) other;
        return new EqualsBuilder().append(codeMinLength,
                castOther.codeMinLength).append(codeMaxLength,
                castOther.codeMaxLength).append(codeRegex, castOther.codeRegex)
                .append(textMaxLength, castOther.textMaxLength).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(codeMinLength)
                .append(codeMaxLength).append(codeRegex).append(textMaxLength)
                .toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("codeMinLength", codeMinLength)
                .append("codeMaxLength", codeMaxLength).append("codeRegex",
                        codeRegex).append("textMaxLength", textMaxLength)
                .toString();
    }

    /**
     * R[h؂܂B<p>
     *
     * ؍
     * <ul>
     *   <li>K{</li>
     *   <li>ŏ</li>
     *   <li>ő啶</li>
     *   <li>K\</li>
     *   <li></li>
     * </ul>
     *
     * @param sampleDomain TvhC
     * @throws ValidationException {@link ValidationException}
     */
    public void validateCode(SampleDomain sampleDomain)
        throws ValidationException {
        String code = sampleDomain.getCode();
        Validate.notBlank(code);
        Validate.lengthInRange(code, codeMinLength, codeMaxLength);
        Validate.match(code, codeRegex);
        SampleDomain found = sampleDomainTable.findByCode(code);
        if (found != null && !sampleDomain.identify(found)) {
            throw new ValidationException("sample.validation.codeUsedByOther",
                    new Object[] {code},
                    "The code '" + code + "' is used by other.");
        }
    }

    /**
     * eLXg؂܂B<p>
     *
     * ؍
     * <ul>
     *   <li>K{</li>
     *   <li>ő啶</li>
     * </ul>
     *
     * @param text eLXg
     * @throws ValidationException {@link ValidationException}
     */
    public void validateText(String text) throws ValidationException {
        Validate.notBlank(text);
        Validate.maxLength(text, textMaxLength);
    }

    /**
     * eLXg؂܂B
     *
     * @param sampleDomain {@link SampleDomain}
     * @throws ValidationException {@link ValidationException}
     */
    public void validateText(SampleDomain sampleDomain)
        throws ValidationException {

        validateText(sampleDomain.getText());
    }

    public int getCodeMinLength() {
        return codeMinLength;
    }

    public void setCodeMinLength(int codeMinLength) {
        this.codeMinLength = codeMinLength;
    }

    public int getCodeMaxLength() {
        return codeMaxLength;
    }

    public void setCodeMaxLength(int codeMaxLength) {
        this.codeMaxLength = codeMaxLength;
    }

    public String getCodeRegex() {
        return codeRegex;
    }

    public void setCodeRegex(String codeRegex) {
        this.codeRegex = codeRegex;
    }

    public int getTextMaxLength() {
        return textMaxLength;
    }

    public void setTextMaxLength(int textMaxLength) {
        this.textMaxLength = textMaxLength;
    }

    public void setSampleDomainTable(SampleDomainTable sampleDomainTable) {
        this.sampleDomainTable = sampleDomainTable;
    }
}
