package org.unitedfront2.domain;

import java.util.Locale;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.Account.Role;
import org.unitedfront2.domain.Account.Status;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.UserOnly;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.test.TransactionalTestCase;

public class DomainFactoryTest extends TransactionalTestCase {

    @Autowired private DomainFactory domainFactory;

    @Test
    public void testPrototypeClass() {
        Account a = domainFactory.prototype(Account.class);
        Assert.assertNotNull(a);
    }

    @Test
    public void testPrototypeObject() {
        Account orig = new Account("tester@example.com", "password", Status.AVAILABLE, Role.ROLE_USER);
        orig.encrypt();
        Account a = domainFactory.prototype(orig, Account.class);
        Assert.assertNotNull(a);
        Assert.assertNotSame(orig, a);
        Assert.assertEquals(orig, a);
    }

    @Test
    public void testPrototypeObjectقȂCX^X𐶐Ă() throws MailAddrUsedByOtherException {
        Account orig = new Account("tester@example.com", "password", Status.AVAILABLE, Role.ROLE_USER);
        orig.encrypt();
        orig = domainFactory.prototype(orig, Account.class);
        orig.store();
        Account a1 = domainFactory.prototype(orig, Account.class);
        Account a2 = domainFactory.prototype(orig, Account.class);
        Assert.assertNotSame(a1, a2);
        Assert.assertEquals(a1, a2);
    }

    @Test
    public void testPrototypevpeB̃vpeBhC̏ꍇ͐VꂽhCݒ肳Ă() {
        AccessControl rac = domainFactory.prototype(UserOnly.class);
        AccessControl wac = domainFactory.prototype(OwnerOnly.class);
        Message orig = domainFactory.prototype(new Message("m", 1, 2, rac, wac));
        orig.setSubject("eXg", Locale.JAPANESE);
        orig.setBody("̓eXgłB", Locale.JAPANESE);
        Message dest = domainFactory.prototype(orig, Message.class);
        Assert.assertNotSame(orig, dest);
        Assert.assertEquals(orig, dest);
        Assert.assertNotSame(orig.getReadAccessControl(), dest.getReadAccessControl());
        Assert.assertEquals(orig.getReadAccessControl(), dest.getReadAccessControl());
    }
}
