package org.unitedfront2.dao;

import java.util.List;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class MailDaoTest extends TransactionalTestCaseWithInitialData {

    @Autowired private MailDao mailDao;

    @Autowired
    private DateDao dateDao;

    @Test
    public void testRegister() {
        Mail mail = new Mail(simpleUser1.getId(), simpleUser2.getId(), "1", "{1");
        mail.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail.setSentDate(dateDao.getCurrentDate());

        mailDao.register(mail);
        Assert.assertNotNull(mail.getId());
        Assert.assertEquals(mail, mailDao.find(mail.getId()));
    }

    @Test
    public void testRegisterXbh() {
        Mail mail1 = new Mail(simpleUser1.getId(), simpleUser2.getId(), "1", "{1");
        mail1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail1);
        Mail mail2 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2", "{2");
        mail2.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2.setSentDate(dateDao.getCurrentDate());

        mailDao.register(mail2);
        List<Mail> mails = mailDao.findThreads(simpleUser1.getId(), 0, 5);
        Assert.assertEquals(2, mails.size());
        Assert.assertEquals(mail2, mails.get(0));
        Assert.assertEquals(mail1, mails.get(1));
    }

    @Test
    public void testRegisterolnullłM() {
        Mail mail = new Mail(simpleUser1.getId(), null, "1", "{1");
        mail.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail);
        Mail found = mailDao.find(mail.getId());
        Assert.assertEquals(mail, found);
    }

    @Test
    public void testRegisterParentId() {
        Mail mail1 = new Mail(simpleUser1.getId(), simpleUser2.getId(), "1", "{1");
        mail1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail1);
        Mail mail2 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2", "{2");
        mail2.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2.setSentDate(dateDao.getCurrentDate());

        mailDao.register(mail2, mail1.getId());
        Assert.assertNotNull(mail1.getId());
        Assert.assertNotNull(mail1.getCode());
        Assert.assertNotNull(mail1.getSentDate());
        Assert.assertEquals(mail1, mailDao.find(mail1.getId()));
        Assert.assertEquals(mail2, mailDao.findThread(mail1.getId()).getTail());
    }

    @Test
    public void testRegisterParentIdolnullłM() {
        Mail mail1 = new Mail(simpleUser1.getId(), simpleUser2.getId(), "1", "{1");
        mail1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail1);
        Mail mail2 = new Mail(simpleUser2.getId(), null, "2", "{2");
        mail2.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2, mail1.getId());
        Mail thread = mailDao.findThread(mail1.getId());
        Assert.assertEquals(2, thread.getCount());
        Assert.assertEquals(mail1, thread);
        Assert.assertEquals(mail2, thread.getNext());
    }

    @Test
    public void testFindByCode() {
        Mail mail = new Mail(simpleUser1.getId(), simpleUser2.getId(), "1", "{1");
        mail.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail);
        Assert.assertNotNull(mailDao.find(mail.getId()));
    }

    @Test
    public void testFindByCodeȂ() {
        Assert.assertNull(mailDao.find(-1));
    }

    @Test
    public void testFindThread() {
        Mail mail1 = new Mail(simpleUser1.getId(), simpleUser2.getId(), "1", "{1");
        mail1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail1);
        Mail mail2_1 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2", "{2");
        mail2_1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2_1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2_1, mail1.getId());
        Mail mail2_2 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2", "{2");
        mail2_2.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2_2.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2_2, mail1.getId());
        Mail mail = mailDao.findThread(mail2_1.getId());
        Assert.assertEquals(3, mail.getCount());
        Assert.assertEquals(mail1, mail);
        Assert.assertEquals(mail2_1, mail.getNext());
        Assert.assertEquals(mail2_2, mail.getNext().getNext());
    }

    @Test
    public void testFindThreadȂ() {
        Assert.assertNull(mailDao.findThread(-1));
    }

    @Test
    public void testFindThreadByCode() {
        Mail mail1 = new Mail(simpleUser1.getId(), simpleUser2.getId(), "1", "{1");
        mail1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail1);
        Mail mail2_1 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2", "{2");
        mail2_1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2_1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2_1, mail1.getId());
        Mail mail2_2 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2", "{2");
        mail2_2.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2_2.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2_2, mail1.getId());
        Mail mail = mailDao.findThreadByCode(mail2_1.getCode());
        Assert.assertEquals(3, mail.getCount());
        Assert.assertEquals(mail1, mail);
        Assert.assertEquals(mail2_1, mail.getNext());
        Assert.assertEquals(mail2_2, mail.getNext().getNext());
    }

    @Test
    public void testFindThreadByCodeȂ() {
        Assert.assertNull(mailDao.findThreadByCode("_____"));
    }

    @Test
    public void testFindThreads() throws InterruptedException {
        Mail mail1 = new Mail(simpleUser1.getId(), simpleUser2.getId(), "1", "{1");
        mail1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail1);
        Mail mail2 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2", "{2");
        mail2.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2);
        Mail mail2_1 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2_1", "{2_1");
        mail2_1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2_1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2_1, mail2.getId());
        Mail mail2_2 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2_2", "{2_2");
        mail2_2.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2_2.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2_2, mail2_1.getId());

        List<Mail> threads = mailDao.findThreads(simpleUser1.getId(), 0, 5); 
        Assert.assertEquals(2, threads.size());
        Assert.assertEquals(3, threads.get(0).getCount());
        Assert.assertEquals(mail2, threads.get(0));
        Assert.assertEquals(mail2_1, threads.get(0).getNext());
        Assert.assertEquals(mail2_2, threads.get(0).getNext().getNext());
        Assert.assertEquals(1, threads.get(1).getCount());
        Assert.assertEquals(mail1, threads.get(1));
    }

    @Test
    public void testCountThreads() {
        Mail mail1 = new Mail(simpleUser1.getId(), simpleUser2.getId(), "1", "{1");
        mail1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail1);
        Mail mail2 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2", "{2");
        mail2.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2);
        int count = mailDao.countThreads(simpleUser1.getId());
        Assert.assertEquals(2, count);
    }

    @Test
    public void testCountUnreadMail() {
        Mail mail1 = new Mail(simpleUser1.getId(), simpleUser2.getId(), "1", "{1");
        mail1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail1);
        Mail mail2 = new Mail(simpleUser2.getId(), simpleUser1.getId(), "2", "{2");
        mail2.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2);
        Mail mail2_1 = new Mail(simpleUser1.getId(), simpleUser2.getId(), "2_1", "{2_1");
        mail2_1.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2_1.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2_1, mail2.getId());
        mailDao.updateRead(mail2_1.getId(), true);
        Mail mail2_2 = new Mail(simpleUser1.getId(), simpleUser2.getId(), "2_2", "{2_2");
        mail2_2.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail2_2.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail2_2, mail2.getId());
        int count = mailDao.countUnreadMail(simpleUser1.getId());
        Assert.assertEquals(2, count);
    }

    @Test
    public void testUpdateRead() {
        Mail mail = new Mail(simpleUser1.getId(), simpleUser2.getId(), "", "{");
        mail.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        mail.setSentDate(dateDao.getCurrentDate());
        mailDao.register(mail);

        mailDao.updateRead(mail.getId(), true);
        Assert.assertTrue(mailDao.find(mail.getId()).isRead());
    }
}
