package org.unitedfront2.dao;

import java.util.List;
import java.util.Set;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class FriendDaoTest extends TransactionalTestCaseWithInitialData {

    @Autowired private FriendDao friendDao;

    @Autowired private SimpleUserDao simpleUserDao;

    @Test
    public void testFind() {
        friendDao.register(simpleUser1.getId(), simpleUser2.getId());

        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        SimpleUser friend = friendDao.find(simpleUser1.getId(), simpleUser2.getId());
        Assert.assertNotNull(friend);
        Assert.assertEquals(simpleUser2, friend);
    }

    @Test
    public void testFindȂ() {
        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        SimpleUser friend = friendDao.find(simpleUser1.getId(), simpleUser2.getId());
        Assert.assertNull(friend);
    }

    @Test
    public void testFind݂Ȃ[UȂ() {
        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        SimpleUser friend = friendDao.find(simpleUser1.getId(), -1);
        Assert.assertNull(friend);
    }

    @Test
    public void testFindByUserId() {
        friendDao.register(simpleUser1.getId(), simpleUser2.getId());
        friendDao.register(simpleUser1.getId(), simpleUser3.getId());
        Set<SimpleUser> friends = friendDao.findByUserId(simpleUser1.getId());
        Assert.assertEquals(2, friends.size());
        Assert.assertTrue(SimpleUser.exists(friends, simpleUser2));
        Assert.assertTrue(SimpleUser.exists(friends, simpleUser3));
    }

    @Test
    public void testFindByUserIdFBȂ() {
        Set<SimpleUser> friends = friendDao.findByUserId(simpleUser1.getId());
        Assert.assertEquals(0, friends.size());
    }

    @Test
    public void testFindByUserId݂Ȃ[U() {
        Set<SimpleUser> friends = friendDao.findByUserId(-1);
        Assert.assertEquals(0, friends.size());
    }

    @Test
    public void testFindRandomly() {
        friendDao.register(simpleUser1.getId(), simpleUser2.getId());
        friendDao.register(simpleUser1.getId(), simpleUser3.getId());

        List<SimpleUser> friends = friendDao.findRandomly(simpleUser1.getId(), 1);
        Assert.assertEquals(1, friends.size());

        friends = friendDao.findRandomly(simpleUser1.getId(), 2);
        Assert.assertEquals(2, friends.size());
        Assert.assertTrue(SimpleUser.exists(friends, simpleUser2));
        Assert.assertTrue(SimpleUser.exists(friends, simpleUser3));

        friends = friendDao.findRandomly(simpleUser1.getId(), 5);
        Assert.assertEquals(2, friends.size());
        Assert.assertTrue(SimpleUser.exists(friends, simpleUser2));
        Assert.assertTrue(SimpleUser.exists(friends, simpleUser3));
    }

    @Test
    public void testRegister() {
        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        Assert.assertTrue(simpleUser1.getId().intValue() != simpleUser2.getId().intValue());
        Assert.assertNull(friendDao.find(simpleUser1.getId(), simpleUser2.getId()));
        friendDao.register(simpleUser1.getId(), simpleUser2.getId());
        Assert.assertNotNull(friendDao.find(simpleUser1.getId(), simpleUser2.getId()));
    }

    @Test
    public void testDelete() {
        friendDao.register(simpleUser1.getId(), simpleUser2.getId());

        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        Assert.assertNotNull(simpleUserDao.find(simpleUser2.getId()));
        Assert.assertNotNull(friendDao.find(simpleUser1.getId(), simpleUser2.getId()));
        friendDao.delete(simpleUser1.getId(), simpleUser2.getId());
        Assert.assertNull(friendDao.find(simpleUser1.getId(), simpleUser2.getId()));
    }
}
