<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>
<div>
  <h2><spring:message code="${pageTitleCode}"/></h2>
  <p><spring:message code="community.Form.body"/></p>
  <form:form commandName="community">
    <input type="hidden" name="_eventId" value="submit"/>
    <input type="hidden" name="_flowExecutionKey" value="${flowExecutionKey}"/>
    <div class="element">
      * <spring:message code="community.type"/>:
      <ul class="indent noneMarker">
        <li>
          <label for="community.type.SingleThreadCommunity">
            <input id="community.type.SingleThreadCommunity" type="radio" name="type" value="SingleThreadCommunity"<c:if test="${community.class.simpleName == 'SingleThreadCommunity'}"> checked="checked"</c:if><c:if test="${!canChangeToSingleThreadCommunity}"> disabled="disabled"</c:if>/>
            <spring:message code="community.type.SingleThreadCommunity"/>
          </label>
        </li>
        <li>
          <label for="community.type.MultiThreadCommunity">
            <input id="community.type.MultiThreadCommunity" type="radio" name="type" value="MultiThreadCommunity"<c:if test="${community.class.simpleName == 'MultiThreadCommunity'}"> checked="checked"</c:if><c:if test="${!canChangeToMultiThreadCommunity}"> disabled="disabled"</c:if>/>
            <spring:message code="community.type.MultiThreadCommunity"/>
          </label>
        </li>
      </ul>
    </div>
    <div class="element">
      * <spring:message code="code"/>: <form:errors path="code" cssClass="errors"/><br/>
      <form:input path="code" maxlength="${validator.codeMaxLength}"/> ( <spring:message code="blog.validation.code" arguments="${validator.codeMaxLength}"/> )
    </div>
    <div class="element">
      <input type="submit" value="<spring:message code="toNext"/>" class="button" onclick="this.disabled='disabled';this.form.submit();"/>
    </div>
  </form:form>
  <uf2:script>
    document.getElementById('community.type.${community.class.simpleName}').focus();
  </uf2:script>
</div>
