package org.unitedfront2.web.tags;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.HtmlUtils;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.User;
import org.unitedfront2.web.WebUtils;

/**
 * [UƂ̃vtB[ւ̃N𐶐^OCułB̏ꍇɃvtB[ւ̃N\
 * ܂B
 *
 * <ul>
 *   <li>N <code>true</code> ɐݒ肳Ă</li>
 *   <li>̃vtB[</li>
 *   <li>[U <code>profile</code> vpeBĂAQƉ\Ɣfł</li>
 * </ul>
 *
 * @author kurokkie
 *
 */
public class UserTag extends TagSupport {

    /** O */
    protected transient Log logger = LogFactory.getLog(getClass());

    /** VAԍ */
    private static final long serialVersionUID = 7866827409123399554L;

    /** [U */
    private User user;

    /**
     * NIɕtȂ <code>true</code> AIɕtȂȂȂ
     * <code>false</code>
     */
    private Boolean link;

    @Override
    public int doStartTag() throws JspException {
        User user = getUser();
        if (user == null) {
            outAnonymous();
            return SKIP_BODY;
        }

        if (!(user instanceof SimpleUser)) {
            outWithLink();
            return SKIP_BODY;
        }

        if (!(pageContext.getRequest() instanceof HttpServletRequest)) {
            out();
            return SKIP_BODY;
        }

        HttpServletRequest request = (HttpServletRequest) pageContext
            .getRequest();
        User me = WebUtils.findUser(request.getSession(false));

        SimpleUser u = (SimpleUser) user;
        return caseUser(me, u);
    }

    private int caseUser(User me, SimpleUser u) throws JspException {
        if (link != null && link) {
            // Nw肵ĂȂQƉ\
            outWithLink();
        } else if (link != null && !link) {
            // NȂƂĂȂQƕs
            out();
        } else if (me != null && u.identify(me)) {
            // ̃vtB[͎QƉ\
            outWithLink();
        } else if (u.getProfile() == null) {
            // vtB[ݒ肳ĂȂꍇ͎Qƕsƍl
            out();
        } else if (u.getProfile().canRead(me)) {
            // ̃[UŃANZX\Ȃ烊N\
            outWithLink();
        } else {
            // Qƕs
            out();
        }
        return SKIP_BODY;
    }

    private void out() throws JspException {
        Writer out = pageContext.getOut();
        try {
            String name = HtmlUtils.htmlEscape(user.getName());
            out.write(name);
        } catch (IOException e) {
            throw new JspException(e);
        }
    }

    private void outWithLink() throws JspException {
        Writer out = pageContext.getOut();
        try {
            String name = HtmlUtils.htmlEscape(user.getName());
            out.write("<a href=\""
                + Utils.createUrl("/profile/" + user.getCode() + "/index.html",
                        pageContext)
                + "\" title=\"" + name + "\">" + name + "</a>");
        } catch (IOException e) {
            throw new JspException(e);
        }
    }

    private void outAnonymous() throws JspException {
        Writer out = pageContext.getOut();
        try {
            out.write("<span class=\"thin\">");
            out.write(RequestContextUtils.getWebApplicationContext(
                    pageContext.getRequest()).getMessage("anonymous", null,
                            WebUtils.getLocale(Utils.getRequest(pageContext))));
            out.write("</span>");
        } catch (IOException e) {
            throw new JspException(e);
        }
    }

    protected User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setLink(boolean link) {
        this.link = link;
    }
}
