package org.unitedfront2.web.tags;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.unitedfront2.domain.Terminal;
import org.unitedfront2.web.WebUtils;

/**
 * <code>SCRIPT</code> HTML ^O\^OłBoC̃ANZX̏ꍇÃ^Oň͂܂
 * Rec͕]܂B
 *
 * @author kurokkie
 *
 */
public class ScriptTag extends TagSupport {

    /** VAԍ */
    private static final long serialVersionUID = 3034480387393849892L;

    @Override
    public int doStartTag() throws JspException {
        Terminal t = WebUtils.findTerminal(Utils.getRequest(pageContext));
        if (t == Terminal.PC) {
            try {
                this.pageContext.getOut().write(
                        "<script type=\"text/javascript\">\n");
            } catch (IOException e) {
                throw new JspException(e);
            }
            return EVAL_BODY_INCLUDE;
        } else {
            return SKIP_BODY;
        }
    }

    @Override
    public int doEndTag() throws JspException {
        Terminal t = WebUtils.findTerminal(Utils.getRequest(pageContext));
        if (t == Terminal.PC) {
            try {
                this.pageContext.getOut().write("\n</script>");
            } catch (IOException e) {
                throw new JspException(e);
            }
        }
        return EVAL_PAGE;
    }
}
