package org.unitedfront2.web.mail;

import org.springframework.mail.SimpleMailMessage;
import org.unitedfront2.validation.Validate;

/**
 * {@link SimpleMailMessage} ̌؃NXłB
 *
 * @author kurokkie
 *
 */
public class SimpleMailMessageValidator {

    /**
     * BCC ؂܂B<p>
     *
     *@ؓe
     * <ul>
     *   <li>BCC ݒ肳Ă΁AׂĂ̒l[AhXł邱</li>
     * </ul>
     *
     * @param bcc BCC
     * @throws IllegalArgumentException ؗO
     */
    public void validateBcc(String[] bcc) throws IllegalArgumentException {
        if (bcc != null) {
            validateMailAddr(bcc);
        }
    }

    /**
     * BCC ؂܂B<p>
     *
     *@ؓe
     * <ul>
     *   <li>message  null łȂ</li>
     *   <li>validateBcc(message.getBcc())</li>
     * </ul>
     *
     * @param message [bZ[W
     * @throws IllegalArgumentException ؗO
     * @see #validateBcc(String[])
     */
    public void validateBcc(SimpleMailMessage message)
        throws IllegalArgumentException {
        Validate.notNull(message);
        validateBcc(message.getBcc());
    }

    /**
     * CC ؂܂B<p>
     *
     *@ؓe
     * <ul>
     *   <li>CC ݒ肳Ă΁AׂĂ̒l[AhXł邱</li>
     * </ul>
     *
     * @param cc BCC
     * @throws IllegalArgumentException ؗO
     */
    public void validateCc(String[] cc) throws IllegalArgumentException {
        if (cc != null) {
            validateMailAddr(cc);
        }
    }

    /**
     * CC ؂܂B<p>
     *
     *@ؓe
     * <ul>
     *   <li>message  null łȂ</li>
     *   <li>validateCc(message.getBcc())</li>
     * </ul>
     *
     * @param message [bZ[W
     * @throws IllegalArgumentException ؗO
     * @see #validateCc(String[])
     */
    public void validateCc(SimpleMailMessage message)
        throws IllegalArgumentException {
        Validate.notNull(message);
        validateCc(message.getCc());
    }

    /**
     * ol؂܂B<p>
     *
     *@ؓe
     * <ul>
     *   <li>olݒ肳Ă邱</li>
     *   <li>ol̒l[AhXł邱</li>
     * </ul>
     *
     * @param from ol
     * @throws IllegalArgumentException ؗO
     */
    public void validateFrom(String from) throws IllegalArgumentException {
        Validate.notNull(from);
        Validate.mailAddr(from);
    }

    /**
     * ol؂܂B<p>
     *
     *@ؓe
     * <ul>
     *   <li>message  null łȂ</li>
     *   <li>validateFrom(message.getFrom())</li>
     * </ul>
     *
     * @param message [bZ[W
     * @throws IllegalArgumentException ؗO
     * @see #validateFrom(String)
     */
    public void validateFrom(SimpleMailMessage message)
        throws IllegalArgumentException {
        Validate.notNull(message);
        Validate.mailAddr(message.getFrom());
    }

    /**
     * ԐM؂܂B<p>
     *
     *@ؓe
     * <ul>
     *   <li>ԐM悪ݒ肳Ă΁Al[AhXł邱</li>
     * </ul>
     *
     * @param replyTo ԐM
     * @throws IllegalArgumentException ؗO
     */
    public void validateReplyTo(String replyTo)
        throws IllegalArgumentException {
        if (replyTo != null) {
            Validate.mailAddr(replyTo);
        }
    }

    /**
     * ԐM؂܂B<p>
     *
     *@ؓe
     * <ul>
     *   <li>message  null łȂ</li>
     *   <li>validateReplyTo(message.getReplyTo())</li>
     * </ul>
     *
     * @param message [bZ[W
     * @throws IllegalArgumentException ؗO
     * @see #validateReplyTo(String)
     */
    public void validateReplyTo(SimpleMailMessage message)
        throws IllegalArgumentException {
        Validate.notNull(message);
        validateReplyTo(message.getReplyTo());
    }

    /**
     * ؂܂B<p>
     *
     * ؓe
     * <ul>
     *   <li>ݒ肳Ă邱</li>
     * </ul>
     *
     * @param subject 
     * @throws IllegalArgumentException ؗO
     */
    public void validateSubject(String subject)
        throws IllegalArgumentException {
        Validate.notBlank(subject);
    }

    /**
     * validateSubject(message.getSubject());
     * @param message [bZ[W
     * @throws IllegalArgumentException ؗO
     * @see #validateSubject(String)
     */
    public void validateSubject(SimpleMailMessage message)
        throws IllegalArgumentException {
        validateSubject(message.getSubject());
    }

    /**
     * ؂܂B<p>
     *
     * ؓe
     * <ul>
     *   <li>悪łȂ</li>
     * </ul>
     *
     * @param to 
     * @throws IllegalArgumentException ؗO
     */
    public void validateTo(String[] to) throws IllegalArgumentException {
        Validate.notEmpty(to);
        validateMailAddr(to);
    }

    /**
     * ؂܂B<p>
     *
     *@ؓe
     * <ul>
     *   <li>message  null łȂ</li>
     *   <li>validateTo(message.getTo());</li>
     * </ul>
     *
     * @param message [bZ[W
     * @throws IllegalArgumentException ؗO
     * @see #validateTo(String[])
     */
    public void validateTo(SimpleMailMessage message)
        throws IllegalArgumentException {
        Validate.notNull(message);
        validateTo(message.getTo());
    }

    /**
     * [bZ[ŴׂĂ̍ڂ؂܂B<p>
     *
     * @param message [bZ[W
     * @throws IllegalArgumentException ؗO
     * @see #validateBcc(SimpleMailMessage)
     * @see #validateCc(SimpleMailMessage)
     * @see #validateFrom(SimpleMailMessage)
     * @see #validateReplyTo(SimpleMailMessage)
     * @see #validateSubject(SimpleMailMessage)
     * @see #validateTo(SimpleMailMessage)
     */
    public void validate(SimpleMailMessage message)
        throws IllegalArgumentException {
        validateBcc(message);
        validateCc(message);
        validateFrom(message);
        validateReplyTo(message);
        validateSubject(message);
        validateTo(message);
    }

    private void validateMailAddr(String[] mailAddrs)
        throws IllegalArgumentException {
        for (String mailAddr : mailAddrs) {
            Validate.mailAddr(mailAddr);
        }
    }
}
