package org.unitedfront2.web.mail;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

import javax.servlet.ServletContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.ServletContextAware;

/**
 * [Mp̃ANVNXłB<p>
 *
 * [̑Mɂ́A[ev[gGW {@link SpringMailServiceImpl} 𗘗p
 * Ă܂B[ev[gł́AVXẽ[AhX URL 𗘗pł܂B
 *
 * @author kurokkie
 */
public class MailServiceImpl
    implements MailService, ServletContextAware {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** [MLɂꍇ true Aɂꍇ false */
    private boolean enable;

    /** Spring ̃[MGW */
    private org.springframework.mail.MailSender mailSender;

    /** ̐ړ */
    private String subjectPrefix;

    /**  */
    private String signature;

    /** [bZ[W؃NX */
    private SimpleMailMessageValidator simpleMailMessageValidator;

    /** JX^vpeB */
    private Properties customProperties = new Properties();

    /** {@link ServletContext} */
    private ServletContext servletContext;

    @Override
    public void send(String templateName, Locale locale)
        throws MailSendException {
        send(templateName, new HashMap<String, Object>(), locale);
    }

    @Override
    public void send(String templateName, Map<String, Object> model,
            Locale locale) throws MailSendException {
        if (!enable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending mail is not enable.");
            }
            return;
        }

        WebXmlTemplateSpringMailSender sender
            = new WebXmlTemplateSpringMailSender(templateName, servletContext);
        sender.setSignature(signature);
        sender.setSubjectPrefix(subjectPrefix);
        sender.setSimpleMailMessageValidator(simpleMailMessageValidator);
        sender.setMailSender(mailSender);
        for (Entry<Object, Object> entry : customProperties.entrySet()) {
            model.put(entry.getKey().toString(), entry.getValue());
        }

        sender.send(model, locale);
    }

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setSubjectPrefix(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setMailSender(org.springframework.mail.MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setSimpleMailMessageValidator(
            SimpleMailMessageValidator simpleMailMessageValidator) {
        this.simpleMailMessageValidator = simpleMailMessageValidator;
    }

    public void setCustomProperties(Properties customProperties) {
        this.customProperties = customProperties;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}
