package org.unitedfront2.web.flow;

import java.util.Map;
import java.util.Map.Entry;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.binding.convert.service.DefaultConversionService;

/**
 * JX^}CY\ {@link DefaultConversionService} łB
 *
 * @author kurokkie
 *
 */
public class ConversionServiceImpl extends DefaultConversionService
    implements InitializingBean {

    /** Ro[^ƃGCAX̃}bv */
    private Map<String, Converter> customConverters;

    @Override
    public void afterPropertiesSet() throws Exception {
        for (Entry<String, Converter> entry : customConverters.entrySet()) {
            addConverter(entry.getValue());
            addAlias(entry.getKey(), entry.getValue().getClass());
        }
    }

    public void setCustomConverters(Map<String, Converter> customConverters) {
        this.customConverters = customConverters;
    }
}
