package org.unitedfront2.web.controller.user;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserValidator;
import org.unitedfront2.validation.SpringValidatorSupport;
import org.unitedfront2.validation.ValidationException;

/**
 * [UύX̌؃NXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "userFormValidator")
public class FormValidator
    extends SpringValidatorSupport<SimpleUserValidator, SimpleUser> {

    /**
     * [UR[hƃ[U̒l؂܂B
     *
     * @param simpleUser [U
     * @param errors G[
     */
    @Override
    protected void doValidate(SimpleUser simpleUser, Errors errors) {
        try {
            getOriginalValidator().validateCode(simpleUser);
        } catch (ValidationException e) {
            rejectValue("code", e, errors);
        }

        try {
            getOriginalValidator().validateName(simpleUser);
        } catch (ValidationException e) {
            rejectValue("name", e, errors);
        }
    }

    @Override
    @Autowired
    public void setOriginalValidator(SimpleUserValidator originalValidator) {
        super.setOriginalValidator(originalValidator);
    }
}
