package org.unitedfront2.web.controller.profile;

import java.util.Date;
import java.util.List;

import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.communication.ProfileTable;

/**
 * vtB[EBWFbgp̃r[vyA[NXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profilePublicProfileWidgetPreparer")
public class PublicProfileWidgetPreparer implements ViewPreparer {

    /** [UXgXVԊu (15) */
    public static final int REFLESH_TERM = 60 * 15 * 1000;

    /** ő\ (15) */
    public static final int MAX = 10;

    /** OXV */
    private Date lastRefleshDate;

    /** [UXg̃LbV */
    private List<SimpleUser> cache;

    /** vtB[e[u */
    @Autowired private ProfileTable profileTable;

    @Override
    public void execute(TilesRequestContext tilesContext,
            AttributeContext attributeContext) throws PreparerException {
        attributeContext.putAttribute("users", new Attribute(getUsers()));
    }

    private List<SimpleUser> getUsers() {
        if (cache == null
                || new Date().after(new Date(lastRefleshDate.getTime()
                        + REFLESH_TERM))) {
            cache = profileTable.getPublicProfileOwnersRandomly(MAX);
            lastRefleshDate = new Date();
        }
        return cache;
    }
}
