package org.unitedfront2.web.controller.message;

import java.util.Locale;
import java.util.Map.Entry;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageEntry;
import org.unitedfront2.domain.communication.MessageValidator;
import org.unitedfront2.validation.SpringValidatorSupport;
import org.unitedfront2.validation.Validate;
import org.unitedfront2.validation.ValidationException;

/**
 * bZ[WXVtH[̌؃NXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "messageFormValidator")
public class FormValidator
    extends SpringValidatorSupport<MessageValidator, Message> {

    /**
     * GǧƖ{̒l؂܂B
     *
     * @param message bZ[W
     * @param errors G[
     */
    @Override
    protected void doValidate(Message message, Errors errors) {
        try {
            Validate.notNull(message.getEntryMap());
        } catch (ValidationException e) {
            rejectValue("entryMap", e, errors);
        }

        for (Entry<Locale, MessageEntry> entry
                : message.getEntryMap().entrySet()) {

            try {
                getOriginalValidator().validateSubject(
                        entry.getValue().getSubject());
            } catch (ValidationException e) {
                rejectValue("entryMap['" + entry.getKey().getLanguage()
                        + "'].subject", e, errors);
            }
            try {
                getOriginalValidator().validateBody(
                        entry.getValue().getBody());
            } catch (ValidationException e) {
                rejectValue("entryMap['" + entry.getKey().getLanguage()
                        + "'].body", e, errors);
            }
        }
    }

    @Override
    @Autowired
    public void setOriginalValidator(MessageValidator originalValidator) {
        super.setOriginalValidator(originalValidator);
    }
}
